/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.report;

import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.maachang.report.CellStyleBean;
import org.maachang.report.ExcelUtil;

class CellStyle {
    private String name = null;
    private int startX = -1;
    private int startY = -1;
    private int width = -1;
    private int height = -1;
    private int nowPos = 0;
    private HSSFCellStyle[] styles = null;
    private boolean writeByInsertFlag = false;

    private CellStyle() {
    }

    public CellStyle(String name, HSSFSheet sheet, int startXPos, int startYPos, int width, int height) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30bb\u30eb\u30b9\u30bf\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (sheet == null) {
            throw new IllegalArgumentException("(" + name + ")Excel\u30b7\u30fc\u30c8\u306f\u3001\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (startXPos <= -1 || startXPos > 65535 || --startYPos <= -1 || startYPos > 65535) {
            throw new IllegalArgumentException("(" + name + ")\u958b\u59cb\u30dd\u30b8\u30b7\u30e7\u30f3\u304c\u4e0d\u6b63\u3067\u3059(startX:" + startXPos + " startY:" + startYPos + ")");
        }
        if (width <= -1 || width > 65535 || height <= -1 || height > 65535) {
            throw new IllegalArgumentException("(" + name + ")\u30b3\u30d4\u30fc\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059(width:" + width + " height:" + height + ")");
        }
        HSSFCellStyle[] st = new HSSFCellStyle[width * height];
        int i = 0;
        int k = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                HSSFRow row = sheet.getRow(startYPos + i);
                if (row == null) {
                    st[k] = null;
                    ++k;
                } else {
                    HSSFCell cell = row.getCell((short)(startXPos + j));
                    if (cell == null) {
                        st[k] = null;
                        ++k;
                    } else {
                        st[k] = cell.getCellStyle();
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.name = name;
        this.styles = st;
        this.width = width;
        this.height = height;
        this.startX = startXPos;
        this.startY = startYPos;
        this.nowPos = 0;
        this.writeByInsertFlag = false;
    }

    public CellStyle(String name, HSSFSheet sheet, String startXPos, int startYPos, int width, int height) throws Exception {
        this(name, sheet, ExcelUtil.getPosAz(startXPos), startYPos, width, height);
    }

    public CellStyle(CellStyleBean bean, HSSFSheet sheet) throws Exception {
        this(bean.getName(), sheet, bean.getStartX(), bean.getStartY(), bean.getWidth(), bean.getHeight());
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.name = null;
        this.width = -1;
        this.height = -1;
        this.styles = null;
        this.startX = -1;
        this.startY = -1;
        this.nowPos = 0;
        this.writeByInsertFlag = false;
    }

    public void copy(HSSFSheet sheet, String startXPos, int startYPos) throws Exception {
        this.copy(sheet, ExcelUtil.getPosAz(startXPos), startYPos);
    }

    public void copy(HSSFSheet sheet, int startXPos, int startYPos) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sheet == null) {
            throw new IllegalArgumentException("Excel\u30b7\u30fc\u30c8\u306f\u3001\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (startXPos <= -1 || startXPos > 65535 || startYPos <= -1 || startYPos > 65535) {
            throw new IllegalArgumentException("\u958b\u59cb\u30dd\u30b8\u30b7\u30e7\u30f3\u304c\u4e0d\u6b63\u3067\u3059(startX:" + startXPos + " startY:" + startYPos + ")");
        }
        int i = 0;
        int k = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                if (this.styles[k] == null) {
                    ++k;
                } else {
                    HSSFCell cell;
                    HSSFRow row = sheet.getRow(startYPos + i);
                    if (row == null) {
                        row = sheet.createRow(startYPos + i);
                    }
                    if ((cell = row.getCell((short)(startXPos + j))) == null) {
                        cell = row.createCell((short)(startXPos + j));
                    }
                    cell.setCellStyle(this.styles[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void addStartY(int addNumber) {
        this.startY += addNumber;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUse() {
        return this.styles != null;
    }

    public boolean isGroup(String x, int y) {
        return this.isGroup(ExcelUtil.getPosAz(x), y);
    }

    public boolean isGroup(int x, int y) {
        return x >= this.startX && x <= this.startX + this.width && y >= this.startY && y <= this.startY + this.height;
    }

    public int getNowPos() {
        return this.nowPos;
    }

    public void setNowPos(int nowPos) {
        this.nowPos = nowPos;
    }

    public int getNowRow() {
        return this.startY + this.height * (this.nowPos + 1);
    }

    public void addNowRow() {
        ++this.nowPos;
    }

    public boolean isUnderRow(int y) {
        return this.startY + this.height * (this.nowPos + 1) <= y;
    }

    public void insert() {
        this.writeByInsertFlag = true;
    }

    public boolean isInsert() {
        boolean ret = this.writeByInsertFlag;
        this.writeByInsertFlag = false;
        return ret;
    }

    public String toString() {
        return " CellStyle = {" + " name:" + this.name + " startX:" + this.startX + " startY:" + this.startY + " width:" + this.width + " height:" + this.height + " nowPos:" + this.nowPos + "}";
    }
}

