/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.conf;

import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.conf.ConvIniParam;
import org.maachang.conf.ReadConfigUtil;
import org.maachang.util.atomic.ReadAtomicList;

public class Config {
    private Map<String, Map<String, ReadAtomicList>> params = new ConcurrentHashMap<String, Map<String, ReadAtomicList>>();
    private Map<String, ReadAtomicList> keyByNum = new ConcurrentHashMap<String, ReadAtomicList>();

    public static final Config read(String name) throws Exception {
        Config ret = new Config();
        ReadConfigUtil.readConfig(ret, name);
        return ret;
    }

    public void clear() {
        this.params.clear();
        this.keyByNum.clear();
    }

    public void put(String section, String key, String value) {
        ReadAtomicList keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        ReadAtomicList keys = this.keyByNum.get(section);
        Map<String, ReadAtomicList> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new ConcurrentHashMap<String, ReadAtomicList>();
            this.params.put(section, sectionValue);
            keys = new ReadAtomicList();
            this.keyByNum.put(section, keys);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new ReadAtomicList();
            sectionValue.put(key, keyValue);
            keys.add(key);
        }
        keyValue.add(value);
    }

    public void set(String section, String key, String value) {
        ReadAtomicList keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        Map<String, ReadAtomicList> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new ConcurrentHashMap<String, ReadAtomicList>();
            this.params.put(section, sectionValue);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new ReadAtomicList();
            sectionValue.put(key, keyValue);
        } else {
            keyValue.clear();
        }
        keyValue.add(value);
    }

    public String get(String section, String key, int no) {
        ReadAtomicList value;
        if (section == null || key == null || no < 0) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        Map<String, ReadAtomicList> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > no) {
            return (String)value.get(no);
        }
        return null;
    }

    public boolean getBoolean(String section, String key, int no) {
        return ConvIniParam.getBoolean(this.get(section, key, no));
    }

    public Boolean getBooleanObject(String section, String key, int no) {
        Boolean ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Boolean(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public int getInt(String section, String key, int no) {
        return ConvIniParam.getInt(this.get(section, key, no));
    }

    public Integer getIntObject(String section, String key, int no) {
        Integer ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Integer(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public long getLong(String section, String key, int no) {
        return ConvIniParam.getLong(this.get(section, key, no));
    }

    public Long getLongObject(String section, String key, int no) {
        Long ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Long(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public double getDouble(String section, String key, int no) {
        return ConvIniParam.getDouble(this.get(section, key, no));
    }

    public Double getDoubleObject(String section, String key, int no) {
        Double ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Double(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public InetAddress getInetAddress(String section, String key, int no) {
        return ConvIniParam.getInetAddress(this.get(section, key, no));
    }

    public String[] getAll(String section, String key) {
        ReadAtomicList value;
        if (section == null || key == null) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        Map<String, ReadAtomicList> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > 0) {
            int len = value.size();
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)value.get(i);
                ++i;
            }
            return ret;
        }
        return null;
    }

    public void removeSection(String section) {
        if (section == null) {
            return;
        }
        this.params.remove(section);
        this.keyByNum.remove(section);
    }

    public void removeKey(String section, String key) {
        if (section == null || key == null) {
            return;
        }
        section = section.trim();
        key = key.trim();
        Map<String, ReadAtomicList> sectionValue = this.params.get(section);
        if (sectionValue != null) {
            sectionValue.remove(key);
            ReadAtomicList keys = this.keyByNum.get(section);
            if (keys != null && keys.size() > 0) {
                int len = keys.size();
                int i = 0;
                while (i < len) {
                    if (key.equals(keys.get(i))) {
                        keys.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public int size(String section, String key) {
        ReadAtomicList value;
        if (section == null || key == null) {
            return -1;
        }
        section = section.trim();
        key = key.trim();
        Map<String, ReadAtomicList> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null) {
            return value.size();
        }
        return -1;
    }

    public int size(String section) {
        if (section == null) {
            return -1;
        }
        Map<String, ReadAtomicList> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.size();
        }
        return -1;
    }

    public int size() {
        return this.params.size();
    }

    public String[] getKeys(String section) {
        if (section == null) {
            return null;
        }
        section = section.trim();
        ReadAtomicList keys = this.keyByNum.get(section);
        String[] ret = null;
        if (keys != null && keys.size() > 0) {
            int len = keys.size();
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys.get(i);
                ++i;
            }
        }
        return ret;
    }

    public Object[] getSections() {
        if (this.params != null && this.params.size() > 0) {
            return this.params.keySet().toArray();
        }
        return null;
    }

    public boolean isKeys(String section, String key) {
        if (section == null) {
            return false;
        }
        Map<String, ReadAtomicList> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.get(key) != null;
        }
        return false;
    }

    public boolean isSection(String section) {
        return this.params.get(section = section.trim()) != null;
    }

    public String toString() {
        if (this.params != null && this.params.size() > 0) {
            StringBuilder buf = new StringBuilder();
            Object[] objs = this.params.keySet().toArray();
            int len = objs.length;
            int i = 0;
            while (i < len) {
                buf.append("[").append(objs[i]).append("]\n");
                Map<String, ReadAtomicList> key = this.params.get(objs[i]);
                if (key != null && key.size() > 0) {
                    Object[] sObjs = key.keySet().toArray();
                    int lenJ = sObjs.length;
                    int j = 0;
                    while (j < lenJ) {
                        buf.append("  ").append(sObjs[j]).append("\n");
                        ReadAtomicList emt = key.get(sObjs[j]);
                        if (emt != null && emt.size() > 0) {
                            int lenK = emt.size();
                            buf.append("    ");
                            int k = 0;
                            while (k < lenK) {
                                if (k != 0) {
                                    buf.append(",");
                                }
                                buf.append(emt.get(k));
                                ++k;
                            }
                            buf.append("\n");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

