/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.IOException;
import java.security.MessageDigest;
import org.maachang.util.Digest;
import org.maachang.util.RandSngl;

public class Encryption {
    private static final String CHARSET = "UTF8";
    private static final int STEP_MASK = 127;
    private static final int STEP_IF_MASK = 2;
    private static final int CODE32_TO_CODE256CNV = 256;
    private static final byte[] BACK_PRIVATE_KEY;
    private static final String MD5_DIGEST = "MD5";
    private static final String SHA1_DIGEST = "SHA1";
    private static final int MD5_LENGTH = 16;
    public static final int CHECK_STEPMASK = 255;
    public static final int NOT_STEP = -1;
    public static final int ENCRYPION_KEY_LENGTH = 32;
    public static final int STEP_CODE_LENGTH = 1;
    private static final int[] MASK_ARRAY;
    protected static final char[] convert10To16;
    private final byte[] privateKey = new byte[32];
    private final byte[] publicKey = new byte[32];
    private int encryptonStepCode = 0;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = -2;
        byArray[1] = 1;
        byArray[2] = -19;
        byArray[3] = 18;
        byArray[4] = -36;
        byArray[5] = 35;
        byArray[6] = -53;
        byArray[7] = 52;
        byArray[8] = 69;
        byArray[9] = -70;
        byArray[10] = 86;
        byArray[11] = -87;
        byArray[12] = 103;
        byArray[13] = -104;
        byArray[14] = 120;
        byArray[15] = -121;
        byArray[16] = 118;
        byArray[17] = -119;
        byArray[18] = 101;
        byArray[19] = -102;
        byArray[20] = 84;
        byArray[21] = -85;
        byArray[22] = 67;
        byArray[23] = -68;
        byArray[24] = -51;
        byArray[25] = 50;
        byArray[26] = -34;
        byArray[27] = 33;
        byArray[28] = -17;
        byArray[29] = 16;
        byArray[30] = -1;
        BACK_PRIVATE_KEY = byArray;
        int[] nArray = new int[33];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        nArray[32] = 1;
        MASK_ARRAY = nArray;
        convert10To16 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public Encryption() {
        this.create();
    }

    public Encryption(byte[] privateKey) throws Exception {
        this.create(privateKey);
    }

    protected final void finalize() throws Exception {
        this.clear();
    }

    public final void create() {
        this.clear();
    }

    public final void create(byte[] privateKey) throws Exception {
        if (privateKey == null || privateKey.length != 32) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u306e\u30d7\u30e9\u30a4\u30d9\u30fc\u30c8\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        System.arraycopy(privateKey, 0, this.privateKey, 0, 32);
    }

    public final void clear() {
        System.arraycopy(BACK_PRIVATE_KEY, 0, this.privateKey, 0, 32);
        this.encryptonStepCode = -1;
    }

    public final int encryption(byte[] key, byte[] binary, int offset, int size) throws Exception {
        byte[] baseKey = null;
        byte[] code32Key = null;
        byte[] cd32 = null;
        byte[] cd256 = null;
        if (binary == null || offset < 0 || size < 0 || binary.length < offset + size) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        code32Key = this.publicKey;
        try {
            if (key == null) {
                Encryption.createPublicKey(code32Key);
                baseKey = new byte[32];
                System.arraycopy(code32Key, 0, baseKey, 0, 32);
            } else {
                baseKey = key;
                System.arraycopy(key, 0, code32Key, 0, 32);
            }
            cd32 = Encryption.encryptionEncryptionKey(code32Key, this.privateKey);
            cd256 = Encryption.code32To256(cd32);
            cd32 = null;
            int step = Encryption.getStepNo(baseKey, binary, offset, size);
            this.encryptonStepCode = step & 0xFF;
            step &= 0x7F;
            step = Encryption.cnv256(cd256, this.privateKey, step);
            Encryption.cnvBinary(binary, offset, size, cd256, step);
        }
        finally {
            baseKey = null;
            cd32 = null;
            cd256 = null;
            code32Key = null;
        }
        return this.encryptonStepCode;
    }

    public final void analysis(byte[] key, int step, byte[] binary, int offset, int size) throws Exception {
        int setStep;
        byte[] code32Key = null;
        byte[] cd32 = null;
        byte[] cd256 = null;
        if (key == null || binary == null || offset < 0 || size < 0 || binary.length < offset + size) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        code32Key = this.publicKey;
        try {
            System.arraycopy(key, 0, code32Key, 0, 32);
            cd32 = Encryption.encryptionEncryptionKey(code32Key, this.privateKey);
            cd256 = Encryption.code32To256(cd32);
            cd32 = null;
            setStep = step & 0xFF;
            step &= 0x7F;
            step = Encryption.cnv256(cd256, this.privateKey, step);
            Encryption.cnvBinary(binary, offset, size, cd256, step);
            int checkStep = Encryption.getStepNo(key, binary, offset, size);
            cd32 = null;
            cd256 = null;
            if (setStep != (checkStep & 0xFF)) {
                throw new IOException("\u89e3\u6790\u5bfe\u8c61\u6761\u4ef6(setStep:" + setStep + " : checkStep:" + checkStep + ")\u306f\u4e00\u81f4\u3057\u307e\u305b\u3093");
            }
        }
        finally {
            cd32 = null;
            cd256 = null;
        }
        this.encryptonStepCode = setStep;
    }

    public static final byte[] getUserPasswdByKey(String user, String passwd) throws Exception {
        byte[] ret = null;
        if (user == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("-uSer+");
        buf.append(user);
        buf.append("+PasSwD-");
        buf.append(passwd == null || passwd.length() <= 0 ? "nOpASSwoRd" : passwd);
        ret = Encryption.convertStringByCode32Key(buf.toString());
        return ret;
    }

    public static final byte[] convertStringByCode32Key(String string) throws Exception {
        byte[] code = null;
        byte[] ret = null;
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int[] mask_ary = MASK_ARRAY;
        try {
            try {
                code = Digest.convertBinary(SHA1_DIGEST, string.getBytes(CHARSET));
                code = Encryption.convertBinaryToUnicodeBinary(code, 0, code.length);
                int len = code.length;
                int step = Encryption.getStepNo(code, code, 0, len);
                step = (len & 2) != 0 ? step - len : step + len;
                int originStep = step & 0xFF;
                ret = new byte[32];
                System.arraycopy(BACK_PRIVATE_KEY, 0, ret, 0, 32);
                int i = 0;
                while (i < 32) {
                    ret[i] = (byte)((ret[i] & 0xFF) + step + i & 0xFF);
                    ++i;
                }
                int stepLen = step & 0x1F;
                int stepMask = 31;
                int stepRoop = 0;
                int before = originStep;
                while (stepRoop < stepLen) {
                    i = 0;
                    int j = 0;
                    int k = stepRoop & stepMask;
                    int next = step & 7;
                    int tmp = 0;
                    while (i < len) {
                        k = mask_ary[k];
                        switch (j &= 7) {
                            case 0: {
                                tmp = ((next += ~code[i] & 0xFE) + 1 + ~step & 0x20) >> 4;
                                break;
                            }
                            case 1: {
                                tmp = (((next += code[i] & 0xDF) ^ originStep) & 0x60) >> 5;
                                break;
                            }
                            case 2: {
                                tmp = ((next += ~code[i] & 0x7F) + 1 + ~step & 0x18) >> 3;
                                break;
                            }
                            case 3: {
                                tmp = ((next += ~code[i] & 0xFB) ^ step) & 2;
                                break;
                            }
                            case 4: {
                                tmp = ((next += code[i] & 0xEF) + 1 + ~originStep & 0xC0) >> 6;
                                break;
                            }
                            case 5: {
                                tmp = ((next += ~code[i] & 0xBF) + step & 6) >> 1;
                                break;
                            }
                            case 6: {
                                tmp = ((next += code[i] & 0xF7) + 1 + ~step & 0xC) >> 2;
                                break;
                            }
                            case 7: {
                                tmp = ((next += ~code[i] & 0xFD) + originStep & 0x20) >> 4;
                            }
                        }
                        step = step & next & 7;
                        byte tmpBin = (byte)Encryption.flipCode((byte)(next & 0xFF), step);
                        switch (tmp) {
                            case 0: {
                                int n = k;
                                ret[n] = (byte)(ret[n] + (byte)((~ret[k] & 0xFF) + ~tmpBin & 0xFF));
                                break;
                            }
                            case 1: {
                                int n = k;
                                ret[n] = (byte)(ret[n] + (byte)((ret[k] & 0xFF ^ tmpBin) + originStep & 0xFF));
                                break;
                            }
                            case 2: {
                                int n = k;
                                ret[n] = (byte)(ret[n] + (byte)(ret[k] + (tmpBin & 0xFF) & 0xFF));
                                break;
                            }
                            case 3: {
                                int n = k;
                                ret[n] = (byte)(ret[n] + (byte)(ret[k] + (~tmpBin & 0xFF) + originStep & 0xFF));
                            }
                        }
                        int beforeTmp = before;
                        before = ret[k] & 0xFF;
                        ret[k] = (byte)((ret[k] & 0xFF) + beforeTmp >> 1 & 0xFF);
                        ++i;
                        ++j;
                        ++k;
                    }
                    ++stepRoop;
                }
            }
            catch (Exception e) {
                ret = null;
                throw e;
            }
        }
        finally {
            code = null;
        }
        return ret;
    }

    public static final byte[] getPublicKey() {
        byte[] ret = null;
        ret = new byte[32];
        Encryption.createPublicKey(ret);
        return ret;
    }

    public final byte[] getSettingPrivateKey() {
        return this.privateKey;
    }

    public final byte[] getSettingPublicKey() {
        return this.publicKey;
    }

    public final int getStepCode() {
        return this.encryptonStepCode;
    }

    public static final void createPublicKey(byte[] cd32) {
        if (cd32 == null || cd32.length != 32) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        RandSngl.getInstance().next(cd32);
    }

    private static final byte convert(byte[] key, int no, byte pause) {
        switch (no & 1) {
            case 0: {
                return (byte)(~(pause ^ key[no]));
            }
            case 1: {
                return (byte)(~(pause ^ key[no]));
            }
        }
        return -1;
    }

    private static final byte[] encryptionEncryptionKey(byte[] cd32, byte[] pri32Key) throws Exception {
        byte[] low = null;
        byte[] hight = null;
        byte[] ret = null;
        low = Digest.convertBinary(MD5_DIGEST, cd32);
        hight = Digest.convertBinary(SHA1_DIGEST, pri32Key);
        ret = new byte[32];
        int len = low.length;
        int i = 0;
        int j = 0;
        int k = len - 1;
        while (i < len) {
            ret[j] = Encryption.convert(low, i, cd32[j]);
            ret[j + 1] = Encryption.convert(hight, i, low[k]);
            ++i;
            j += 2;
            --k;
        }
        return ret;
    }

    private static final byte[] code32To256(byte[] key) {
        byte[] tmp = null;
        byte[] binary = null;
        MessageDigest md = null;
        try {
            try {
                binary = new byte[256];
                int len = 31;
                int i = 1;
                int k = 0;
                int next = 0;
                while (i < len) {
                    next = key[i] << 8 & 0xFF00 | key[i + 1];
                    binary[k] = (byte)(next & 0xFF);
                    binary[k + 1] = (byte)((next & 0x1FE) >> 1 & 0xFF);
                    binary[k + 2] = (byte)((next & 0x3FC) >> 2 & 0xFF);
                    binary[k + 3] = (byte)((next & 0x7F8) >> 3 & 0xFF);
                    binary[k + 4] = (byte)((next & 0xFF0) >> 4 & 0xFF);
                    binary[k + 5] = (byte)((next & 0x1FE0) >> 5 & 0xFF);
                    binary[k + 6] = (byte)((next & 0x3FC0) >> 6 & 0xFF);
                    binary[k + 7] = (byte)((next & 0x7F80) >> 7 & 0xFF);
                    k += 8;
                    ++i;
                }
                next = key[len] << 8 & 0xFF00 | key[0];
                binary[k] = (byte)(next & 0xFF);
                binary[k + 1] = (byte)((next & 0x1FE) >> 1 & 0xFF);
                binary[k + 2] = (byte)((next & 0x3FC) >> 2 & 0xFF);
                binary[k + 3] = (byte)((next & 0x7F8) >> 3 & 0xFF);
                binary[k + 4] = (byte)((next & 0xFF0) >> 4 & 0xFF);
                binary[k + 5] = (byte)((next & 0x1FE0) >> 5 & 0xFF);
                binary[k + 6] = (byte)((next & 0x3FC0) >> 6 & 0xFF);
                binary[k + 7] = (byte)((next & 0x7F80) >> 7 & 0xFF);
                int oneLen = 16;
                len = 256;
                md = MessageDigest.getInstance(MD5_DIGEST);
                i = 0;
                int j = oneLen;
                while (j < len) {
                    md.update(binary, j, oneLen);
                    tmp = md.digest();
                    oneLen = tmp.length;
                    oneLen = j + oneLen >= len ? len - j : oneLen;
                    System.arraycopy(tmp, 0, binary, j, oneLen);
                    md.reset();
                    j += oneLen;
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                binary = null;
            }
        }
        finally {
            md = null;
        }
        return binary;
    }

    private static final byte[] convertBinaryToUnicodeBinary(byte[] binary, int offset, int size) throws Exception {
        String tmp = Encryption.convertBinaryTo16String(binary, offset, size);
        return tmp.getBytes(CHARSET);
    }

    private static final int getStepNo(byte[] publicKey, byte[] binary, int offset, int size) {
        int bin;
        int ret = 0;
        int len = offset + size;
        int addCd = (publicKey[binary[offset + size / 2] & 0x1F] & 3) + 1;
        int i = offset;
        int j = 0;
        while (i < len) {
            bin = ~binary[i] & 0xFF;
            ret = (bin & 1) + ((bin & 2) >> 1) + ((bin & 4) >> 2) + ((bin & 8) >> 3) + ((bin & 0x10) >> 4) + ((bin & 0x20) >> 5) + ((bin & 0x40) >> 6) + ((bin & 0x80) >> 7) + (j & 0xFF) + ret;
            i += addCd;
            j += addCd;
        }
        if (!(ret & true)) {
            i = 0;
            while (i < 32) {
                bin = (publicKey[i] & 1) == 0 ? ~publicKey[i] & 0xFF : publicKey[i] & 0xFF;
                ret += (bin & 1) + ((bin & 2) >> 1) + ((bin & 4) >> 2) + ((bin & 8) >> 3) + ((bin & 0x10) >> 4) + ((bin & 0x20) >> 5) + ((bin & 0x40) >> 6) + ((bin & 0x80) >> 7);
                ++i;
            }
        } else {
            i = 0;
            while (i < 32) {
                bin = (publicKey[i] & 1) == 0 ? ~publicKey[i] & 0xFF : publicKey[i] & 0xFF;
                ret -= (bin & 1) + ((bin & 2) >> 1) + ((bin & 4) >> 2) + ((bin & 8) >> 3) + ((bin & 0x10) >> 4) + ((bin & 0x20) >> 5) + ((bin & 0x40) >> 6) + ((bin & 0x80) >> 7);
                ++i;
            }
        }
        return (~ret | 0x80) & 0xFF;
    }

    private static final int cnv256(byte[] code256, byte[] def32, int step) {
        int nowStep = step & 0x7F;
        int len = 256;
        int i = 0;
        int j = 0;
        while (i < len) {
            nowStep = nowStep & code256[i] & 7;
            code256[i] = (byte)Encryption.flipCode(code256[i], nowStep);
            code256[i] = Encryption.convert(def32, j, code256[i]);
            ++i;
            j = j + 1 & 0x1F;
        }
        return nowStep;
    }

    private static final void cnvBinary(byte[] binary, int offset, int size, byte[] code256, int step) {
        int nowStep = step;
        int len = offset + size;
        int i = offset;
        int j = 0;
        while (i < len) {
            nowStep = nowStep & (code256[j] & 0xFF) & 7;
            binary[i] = (byte)Encryption.flipCode(binary[i], nowStep);
            binary[i] = Encryption.convert(code256, j, binary[i]);
            ++i;
            j = j + 1 & 0xFF;
        }
    }

    protected static final int flipCode(int pause, int step) {
        int ret;
        switch (step &= 7) {
            case 1: {
                ret = (pause & 3) << 6 & 0xC0 | (pause & 0xFC) >> 2 & 0x3F;
                break;
            }
            case 2: {
                ret = (pause & 0x3F) << 2 & 0xFC | (pause & 0xC0) >> 6 & 3;
                break;
            }
            case 3: {
                ret = (pause & 1) << 7 & 0x80 | (pause & 0xFE) >> 1 & 0x7F;
                break;
            }
            case 4: {
                ret = (pause & 0xF) << 4 & 0xF0 | (pause & 0xF0) >> 4 & 0xF;
                break;
            }
            case 5: {
                ret = (pause & 0x7F) << 1 & 0xFE | (pause & 0x80) >> 7 & 1;
                break;
            }
            case 6: {
                ret = (pause & 7) << 5 & 0xE0 | (pause & 0xF8) >> 3 & 0x1F;
                break;
            }
            case 7: {
                ret = (pause & 0x1F) << 3 & 0xF8 | (pause & 0xE0) >> 5 & 7;
                break;
            }
            default: {
                ret = pause;
            }
        }
        return ret;
    }

    protected static final int flipBit0x3f(int byte4) {
        return byte4 & 0x40 | byte4 & 0x80 | (byte4 & 1) << 5 & 0x20 | (byte4 & 2) << 3 & 0x10 | (byte4 & 4) << 1 & 8 | (byte4 & 8) >> 1 & 4 | (byte4 & 0x10) >> 3 & 2 | (byte4 & 0x20) >> 5 & 1;
    }

    protected static final int flipBit0x3c(int byte4) {
        return byte4 & 1 | byte4 & 2 | byte4 & 0x40 | byte4 & 0x80 | (byte4 & 4) << 3 & 0x20 | (byte4 & 8) << 1 & 0x10 | (byte4 & 0x10) >> 1 & 8 | (byte4 & 0x20) >> 3 & 4;
    }

    protected static final int flipBit0xc3(int byte4) {
        return byte4 & 4 | byte4 & 8 | byte4 & 0x10 | byte4 & 0x20 | (byte4 & 1) << 7 & 0x80 | (byte4 & 2) << 5 & 0x40 | (byte4 & 0x40) >> 5 & 2 | (byte4 & 0x80) >> 7 & 1;
    }

    protected static final int flipBit0xff(int byte4) {
        return (byte4 & 1) << 7 & 0x80 | (byte4 & 2) << 5 & 0x40 | (byte4 & 4) << 3 & 0x20 | (byte4 & 8) << 1 & 0x10 | (byte4 & 0x10) >> 1 & 8 | (byte4 & 0x20) >> 3 & 4 | (byte4 & 0x40) >> 5 & 2 | (byte4 & 0x80) >> 7 & 1;
    }

    private static final String convertBinaryTo16String(byte[] binary, int offset, int length) {
        char[] cnv = null;
        StringBuffer buf = null;
        String ret = null;
        try {
            try {
                cnv = convert10To16;
                buf = new StringBuffer();
                int len = offset + length;
                int i = offset;
                while (i < len) {
                    int tmp = binary[i] & 0xFF;
                    buf.append(cnv[(tmp & 0xF0) >> 4]);
                    buf.append(cnv[tmp & 0xF]);
                    ++i;
                }
                ret = buf.toString();
            }
            catch (Exception e) {
                ret = " ";
            }
        }
        finally {
            buf = null;
        }
        return ret;
    }
}

