/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import org.maachang.util.BaseRandom;

public class RandomId {
    private static final int ONE4BIT = 5;
    private int size = 0;
    private static final byte[] ENC_CD = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 45};

    private RandomId() {
    }

    public RandomId(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u9577\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.size = size;
    }

    public String get(BaseRandom rand) throws Exception {
        int cnt = 0;
        int len = this.size;
        byte[] buf = new byte[len];
        while (true) {
            int rnd;
            if (cnt + 5 > len) {
                int last = len - cnt;
                switch (last) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        rnd = rand.nextInt();
                        buf[cnt] = ENC_CD[rnd & 0x3F];
                        break;
                    }
                    case 2: {
                        rnd = rand.nextInt();
                        buf[cnt] = ENC_CD[rnd & 0x3F];
                        buf[++cnt] = ENC_CD[(rnd & 0xFC0) >> 6];
                        break;
                    }
                    case 3: {
                        rnd = rand.nextInt();
                        buf[cnt] = ENC_CD[rnd & 0x3F];
                        buf[++cnt] = ENC_CD[(rnd & 0xFC0) >> 6];
                        buf[++cnt] = ENC_CD[(rnd & 0x3F000) >> 12];
                        break;
                    }
                    case 4: {
                        rnd = rand.nextInt();
                        buf[cnt] = ENC_CD[rnd & 0x3F];
                        buf[++cnt] = ENC_CD[(rnd & 0xFC0) >> 6];
                        buf[++cnt] = ENC_CD[(rnd & 0x3F000) >> 12];
                        buf[++cnt] = ENC_CD[(rnd & 0xFC0000) >> 18];
                    }
                }
                break;
            }
            rnd = rand.nextInt();
            buf[cnt] = ENC_CD[rnd & 0x3F];
            buf[++cnt] = ENC_CD[(rnd & 0xFC0) >> 6];
            buf[++cnt] = ENC_CD[(rnd & 0x3F000) >> 12];
            buf[++cnt] = ENC_CD[(rnd & 0xFC0000) >> 18];
            buf[++cnt] = ENC_CD[(rnd & 0x3F000000) >> 24];
            ++cnt;
        }
        return new String(buf, "ISO8859_1");
    }
}

