/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import org.maachang.util.RRV_RandTo;
import org.maachang.util.RandomString;
import org.maachang.util.atomic.AtomicXor128Random;

public class RandomUtil {
    private static final AtomicXor128Random RAND = new AtomicXor128Random();

    public static final void randomize() {
        RAND.setSeed(System.nanoTime());
    }

    public static final int random() {
        return RAND.nextInt();
    }

    public static final int random(int max) {
        return RAND.nextInt(max);
    }

    public static final void randomBinary(byte[] out) throws IllegalArgumentException {
        if (out == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        RAND.nextBytes(out);
    }

    public static final byte[] randomBinary(int length) throws IllegalArgumentException {
        byte[] ret = null;
        if (length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ret = new byte[length];
        RAND.nextBytes(ret);
        return ret;
    }

    public static final String randomString(int size, boolean number, boolean half, boolean full) {
        if (size <= 0 || !number && !half && !full) {
            if (!(number || half || full)) {
                number = true;
            } else {
                return null;
            }
        }
        RRV_RandTo[] check = new RRV_RandTo[3];
        int randSize = 0;
        if (number) {
            check[randSize] = RandomString.prv_num;
            ++randSize;
        }
        if (half) {
            check[randSize] = RandomString.prv_half;
            ++randSize;
        }
        if (full) {
            check[randSize] = RandomString.prv_full;
            ++randSize;
        }
        StringBuilder buf = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            buf.append(check[RandomUtil.random(randSize)].create(RAND));
            ++i;
        }
        return buf.toString();
    }
}

