/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.maachang.util.FileUtil;

public class SerializableSequenceList {
    private RandomAccessFile fp = null;
    private MappedByteBuffer map = null;
    private int length = -1;
    private String name = null;

    private SerializableSequenceList() {
    }

    public SerializableSequenceList(int length, String name) throws Exception {
        RandomAccessFile fp;
        if (name == null || (name = name.trim()).length() <= 0 || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (FileUtil.isFileExists(name)) {
            int len;
            int binLen = (int)FileUtil.getLength(name);
            length = len = binLen / 8;
            fp = new RandomAccessFile(name, "rwd");
        } else {
            fp = new RandomAccessFile(name, "rwd");
            fp.write(new byte[length * 8]);
        }
        this.fp = fp;
        this.map = fp.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, length * 8);
        this.length = length;
        this.name = name;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.fp != null) {
            try {
                this.fp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.map = null;
            System.gc();
        }
        this.fp = null;
        this.map = null;
        this.length = -1;
        this.name = null;
    }

    public boolean isUse() {
        return this.fp != null;
    }

    private void _set(int no, long seq) throws Exception {
        this.map.putLong(no * 8, seq);
    }

    private long _get(int no) throws Exception {
        return this.map.getLong(no * 8);
    }

    public void addSpace(int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (length <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int addLen = (this.length + length) * 8;
        this.fp.setLength(addLen);
        this.fp.close();
        this.fp = null;
        this.map = null;
        System.gc();
        this.fp = new RandomAccessFile(this.name, "rwd");
        this.map = this.fp.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, addLen);
        this.length += length;
    }

    public void set(int no, long seq) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no <= -1 || no >= this.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this._set(no, seq);
    }

    public long get(int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no <= -1 || no >= this.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this._get(no);
    }

    public long getId(int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no <= -1 || no >= this.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        long ret = this._get(no) + 1L;
        this._set(no, ret);
        return ret;
    }

    public int length() {
        return this.length;
    }
}

