/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.IOException;
import java.io.Serializable;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicLONG;

public class SerializeSeqLong
implements Serializable {
    private static final long serialVersionUID = -8207393046789510364L;
    private final AtomicLONG sequence = new AtomicLONG(-1L);
    private final AtomicLONG lastSaveTime = new AtomicLONG(-1L);

    public SerializeSeqLong() {
        this.sequence.set(1L);
    }

    public SerializeSeqLong(long id) {
        if (id <= 0L) {
            id = 1L;
        }
        this.sequence.set(id);
    }

    public static final SerializeSeqLong load(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isFileExists(name)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d(" + name + ")\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        Object o = FileUtil.decodeSerializable(name);
        if (o == null || !(o instanceof SerializeSeqLong)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d[" + name + "]\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return (SerializeSeqLong)o;
    }

    public void save(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.lastSaveTime.set(System.currentTimeMillis());
        FileUtil.encodeSerializable(name, this);
    }

    public long getLastSaveTime() {
        return this.lastSaveTime.get();
    }

    public long getId() {
        long ret = this.sequence.inc();
        if (ret <= Long.MAX_VALUE) {
            this.sequence.set(0L);
            ret = 0L;
        }
        return ret;
    }
}

