/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import org.maachang.util.AbstractBaseRandom;
import org.maachang.util.BaseRandom;
import org.maachang.util.atomic.AtomicLONG;

public class Xor128Random
extends AbstractBaseRandom
implements BaseRandom {
    private static final long serialVersionUID = 746227844186191007L;
    private static final AtomicLONG seedUniquifier = new AtomicLONG(8682522807148012L);
    private int a = 123456789;
    private int b = 362436069;
    private int c = 521288629;
    private int d = 88675123;

    private long nano8bit() {
        return System.nanoTime() & 0xFFL;
    }

    public Xor128Random() {
        this(seedUniquifier.inc());
    }

    public Xor128Random(long seed) {
        this.setSeed(seed);
    }

    public final void setSeed(long seed) {
        seed = seed * this.nano8bit() & 0xFFFFFFFFFFFFFFL;
        this.d = (int)(seed & 0xFFFFFFFFL);
        this.nextInt();
        this.d ^= (int)((seed & 0xFFFFFFFF00000000L) >> 32);
        this.nextInt();
    }

    public final int nextInt() {
        int t;
        int r = t = this.a;
        t <<= 11;
        t ^= r;
        r = t;
        t ^= (r >>= 8);
        this.a = r = this.b;
        this.b = r = this.c;
        this.c = r = this.d;
        t ^= r;
        r >>= 19;
        this.d = r ^= t;
        return r;
    }
}

