/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.maachang.util.atomic.AtomicPrimitive;

public class AtomicDOUBLE
implements Serializable,
AtomicPrimitive {
    private static final long serialVersionUID = 4491352238973168818L;
    private final AtomicLong ato = new AtomicLong(0L);

    public AtomicDOUBLE() {
    }

    public AtomicDOUBLE(double n) {
        this.setting(Double.doubleToLongBits(n));
    }

    public AtomicDOUBLE(Double n) {
        if (n != null) {
            this.setting(Double.doubleToLongBits(n));
        }
    }

    public double get() {
        return Double.longBitsToDouble(this.ato.get());
    }

    public Double getObject() {
        return new Double(this.get());
    }

    public void set(double n) {
        this.setting(Double.doubleToLongBits(n));
    }

    public void set(Double n) {
        if (n != null) {
            this.setting(Double.doubleToLongBits(n));
        }
    }

    public double add(double no) {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Double.doubleToLongBits(Double.longBitsToDouble(n) + no))) {
        }
        return Double.longBitsToDouble(r);
    }

    public double add(Double no) {
        long r;
        long n;
        if (no == null) {
            return -1.0;
        }
        double x = no;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Double.doubleToLongBits(Double.longBitsToDouble(n) + x))) {
        }
        return Double.longBitsToDouble(r);
    }

    public double remove(double no) {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Double.doubleToLongBits(Double.longBitsToDouble(n) - no))) {
        }
        return Double.longBitsToDouble(r);
    }

    public double remove(Double no) {
        long r;
        long n;
        if (no == null) {
            return -1.0;
        }
        double x = no;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Double.doubleToLongBits(Double.longBitsToDouble(n) - x))) {
        }
        return Double.longBitsToDouble(r);
    }

    public double inc() {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Double.doubleToLongBits(Double.longBitsToDouble(n) + 1.0))) {
        }
        return Double.longBitsToDouble(r);
    }

    public double dec() {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Double.doubleToLongBits(Double.longBitsToDouble(n) - 1.0))) {
        }
        return Double.longBitsToDouble(r);
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public Object base() {
        return this.ato;
    }

    public int getType() {
        return 8;
    }

    private void setting(long no) {
        while (!this.ato.compareAndSet(this.ato.get(), no)) {
        }
    }
}

