/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import org.maachang.util.AbstractBaseRandom;
import org.maachang.util.BaseRandom;
import org.maachang.util.atomic.AtomicLONG;

public class AtomicDrand48Random
extends AbstractBaseRandom
implements BaseRandom {
    private static final long serialVersionUID = 907130768057232988L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static final AtomicLONG seedUniquifier = new AtomicLONG(8682522807148012L);
    private final AtomicLONG s = new AtomicLONG(20017429951246L);

    private long nano8bit() {
        return System.nanoTime() & 0xFFL;
    }

    public AtomicDrand48Random() {
        this(seedUniquifier.inc());
    }

    public AtomicDrand48Random(long seed) {
        this.setSeed(seed);
    }

    public final void setSeed(long seed) {
        seed = seed * this.nano8bit() & 0xFFFFFFFFFFFFL;
        this.s.set((seed << 16) + 13070L & 0xFFFFFFFFFFFFL);
    }

    public final int nextInt() {
        long x = this.s.get();
        x = x * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        this.s.set(x);
        return (int)(x >> 16);
    }
}

