/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.maachang.util.atomic.AtomicPrimitive;

public class AtomicINT
implements Serializable,
AtomicPrimitive {
    private static final long serialVersionUID = 2146413862872622803L;
    private final AtomicInteger ato = new AtomicInteger(0);

    public AtomicINT() {
    }

    public AtomicINT(int n) {
        this.setting(n);
    }

    public AtomicINT(Integer n) {
        if (n != null) {
            this.setting(n);
        }
    }

    public int get() {
        return this.ato.get();
    }

    public Integer getObject() {
        return new Integer(this.ato.get());
    }

    public void set(int n) {
        this.setting(n);
    }

    public void set(Integer n) {
        if (n != null) {
            this.setting(n);
        }
    }

    public int add(int no) {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n + no)) {
        }
        return r;
    }

    public int add(Integer no) {
        int r;
        int n;
        if (no == null) {
            return -1;
        }
        int x = no;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n + x)) {
        }
        return r;
    }

    public int remove(int no) {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n - no)) {
        }
        return r;
    }

    public int remove(Integer no) {
        int r;
        int n;
        if (no == null) {
            return -1;
        }
        int x = no;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n - x)) {
        }
        return r;
    }

    public int inc() {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n + 1)) {
        }
        return r;
    }

    public int dec() {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n - 1)) {
        }
        return r;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public Object base() {
        return this.ato;
    }

    public int getType() {
        return 4;
    }

    private void setting(int no) {
        while (!this.ato.compareAndSet(this.ato.get(), no)) {
        }
    }
}

