/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.maachang.util.atomic.AtomicPrimitive;

public class AtomicLONG
implements Serializable,
AtomicPrimitive {
    private static final long serialVersionUID = 9075166340272133267L;
    private final AtomicLong ato = new AtomicLong(0L);

    public AtomicLONG() {
    }

    public AtomicLONG(long n) {
        this.setting(n);
    }

    public AtomicLONG(Long n) {
        if (n != null) {
            this.setting(n);
        }
    }

    public long get() {
        return this.ato.get();
    }

    public Long getObject() {
        return new Long(this.ato.get());
    }

    public void set(long n) {
        this.setting(n);
    }

    public void set(Long n) {
        if (n != null) {
            this.setting(n);
        }
    }

    public long add(long no) {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n + no)) {
        }
        return r;
    }

    public long add(Long no) {
        long r;
        long n;
        if (no == null) {
            return -1L;
        }
        long x = no;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n + x)) {
        }
        return r;
    }

    public long remove(long no) {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n - no)) {
        }
        return r;
    }

    public long remove(Long no) {
        long r;
        long n;
        if (no == null) {
            return -1L;
        }
        long x = no.intValue();
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n - x)) {
        }
        return r;
    }

    public long inc() {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n + 1L)) {
        }
        return r;
    }

    public long dec() {
        long r;
        long n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = n - 1L)) {
        }
        return r;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public Object base() {
        return this.ato;
    }

    public int getType() {
        return -5;
    }

    private void setting(long no) {
        while (!this.ato.compareAndSet(this.ato.get(), no)) {
        }
    }
}

