/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.maachang.util.OList;
import org.maachang.util.atomic.AtomicARRAY;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicOBJECT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadAtomicList
implements OList,
Serializable {
    private static final long serialVersionUID = -7622272629442735296L;
    private final AtomicOBJECT<AtomicARRAY<Object>> array = new AtomicOBJECT();
    private final AtomicINT startLength = new AtomicINT(8);
    private final AtomicINT length = new AtomicINT(8);
    private final AtomicINT nowLength = new AtomicINT(0);
    private final ReentrantLock sync = new ReentrantLock();

    public ReadAtomicList() {
    }

    public ReadAtomicList(int length) {
        length = length < 2 || length > Integer.MAX_VALUE ? 8 : length;
        this.startLength.set(length);
        this.length.set(length);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void clear() {
        this.sync.lock();
        try {
            this.array.set(null);
            this.length.set(this.startLength.get());
            this.nowLength.set(0);
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public final void add(Object value) {
        this.sync.lock();
        try {
            AtomicARRAY<Object> info = null;
            AtomicARRAY<Object> tmp = null;
            info = this.array.get();
            int length = this.length.get();
            int nowSize = this.nowLength.get();
            if (info == null) {
                info = new AtomicARRAY(length);
                info.set(value, nowSize);
                this.array.set(info);
                this.nowLength.inc();
            } else if (info.size() <= nowSize) {
                tmp = info;
                info = new AtomicARRAY(length *= 2);
                ReadAtomicList.arraycopy(tmp, 0, info, 0, nowSize);
                info.set(value, nowSize);
                this.length.set(length);
                this.array.set(info);
                this.nowLength.inc();
            } else {
                info.set(value, nowSize);
                this.nowLength.inc();
            }
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public final void set(int no, Object value) {
        this.sync.lock();
        try {
            int nowLen = this.nowLength.get();
            AtomicARRAY<Object> info = this.array.get();
            if (no < 0 || no >= nowLen) {
                return;
            }
            info.set(value, no);
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public final Object remove(int no) {
        this.sync.lock();
        try {
            AtomicARRAY<Object> info = null;
            AtomicARRAY<Object> tmp = null;
            Object ret = null;
            int nowSize = this.nowLength.get();
            int length = this.length.get();
            int newLength = this.length.get();
            if (no < 0 || no >= nowSize || nowSize == 0) {
                Object var9_8 = null;
                return var9_8;
            }
            info = this.array.get();
            ret = info.get(no);
            info.set(null, no);
            if (no == 0) {
                tmp = info;
                ReadAtomicList.arraycopy(tmp, 1, info, 0, nowSize - 1);
                info.set(null, nowSize - 1);
            } else if (nowSize - no != 1) {
                tmp = info;
                ReadAtomicList.arraycopy(tmp, 0, info, 0, no);
                ReadAtomicList.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
                info.set(null, nowSize - 1);
            }
            if (--nowSize == 0) {
                info = null;
                newLength = this.startLength.get();
            } else if ((double)length * 0.375 >= (double)nowSize) {
                newLength = length / 2;
                tmp = new AtomicARRAY(newLength);
                ReadAtomicList.arraycopy(info, 0, tmp, 0, newLength);
                info = tmp;
            }
            this.array.set(info);
            this.nowLength.set(nowSize);
            this.length.set(newLength);
            info = null;
            tmp = null;
            Object object = ret;
            return object;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public final Object get(int no) {
        return this.array.get().get(no);
    }

    @Override
    public final int size() {
        return this.nowLength.get();
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ ");
        int len = this.nowLength.get();
        int i = 0;
        while (i < len) {
            Object o;
            if (i != 0) {
                buf.append(", ");
            }
            if ((o = this.array.get().get(i)) == null) {
                buf.append("null@null");
            } else {
                buf.append(o).append("@").append(o.getClass().getName());
            }
            ++i;
        }
        return buf.append(" ]").toString();
    }

    private static final void arraycopy(AtomicARRAY<Object> src, int sp, AtomicARRAY<Object> dest, int dp, int len) {
        int i = 0;
        while (i < len) {
            dest.set(src.get(sp + i), dp + i);
            ++i;
        }
    }
}

