/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.nativeio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.util.Os;
import org.maachang.util.atomic.AtomicBOOL;

class NativeIO {
    private static final AtomicBOOL initFlag = new AtomicBOOL(false);

    static {
        String name = "mntv";
        String lib = String.valueOf(name) + "-" + "1.00";
        switch (Os.getInstance().getOS()) {
            case 33: {
                lib = String.valueOf(lib) + ".dll";
                System.load(NativeIO.targetDynamincLib(true, lib));
                initFlag.set(true);
                break;
            }
            case 1: {
                lib = String.valueOf(lib) + ".so";
                System.load(NativeIO.targetDynamincLib(true, lib));
                initFlag.set(true);
                break;
            }
            default: {
                initFlag.set(false);
            }
        }
    }

    private static final String targetDynamincLib(boolean mode, String lib) {
        String sp = System.getProperty("file.separator");
        File targetDir = null;
        targetDir = new File(System.getProperty("user.home") + sp + ".lib_work");
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File outFile = new File(targetDir, lib);
        if (mode) {
            BufferedInputStream is;
            String ntvDir = "org/maachang/util/nativeio/native/";
            if (!(ntvDir = ntvDir.trim()).endsWith("/")) {
                ntvDir = String.valueOf(ntvDir) + "/";
            }
            if (ntvDir.startsWith("/")) {
                ntvDir = ntvDir.substring(1);
            }
            if (NativeIO.isLibFile(outFile, is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(String.valueOf(ntvDir) + lib)))) {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        try {
                            int n;
                            while ((n = ((InputStream)is).read()) > -1) {
                                ((OutputStream)os).write(n);
                            }
                            ((OutputStream)os).flush();
                        }
                        finally {
                            ((InputStream)is).close();
                            is = null;
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                        os = null;
                    }
                }
                catch (Exception e) {
                    outFile = null;
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                is = null;
            }
        }
        if (outFile != null) {
            return outFile.getAbsolutePath();
        }
        return null;
    }

    private static final boolean isLibFile(File f, InputStream in) {
        boolean ret = false;
        try {
            int len;
            ret = !f.exists() ? true : (len = (int)f.length()) <= 0 || len != in.available();
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }

    protected static final boolean useInit() {
        return initFlag.get();
    }

    protected NativeIO() {
    }

    protected static native long open(int var0, int var1, byte[] var2);

    protected static native void close(long var0);

    protected static native int read(long var0, long var2, byte[] var4, int var5, int var6);

    protected static native int write(long var0, long var2, byte[] var4, int var5, int var6);

    protected static native long getLength(long var0);

    protected static native int setLength(long var0, long var2);
}

