/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.nativeio;

import java.io.IOException;
import java.io.InputStream;
import org.maachang.util.nativeio.NativeIO;
import org.maachang.util.nativeio.NativeIODefine;

class NativeInputStream
extends InputStream {
    private static final int TEMP_LEN = 4096;
    private final byte[] temp = new byte[4096];
    private int position = 0;
    private int length = 0;
    private long handle = -1L;
    private long fileSize = 0L;
    private long allPos = 0L;

    private NativeInputStream() {
    }

    public NativeInputStream(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!NativeIODefine.useFile(name)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        name = NativeIODefine.fullPath(name);
        this.handle = NativeIO.open(1, 0, NativeIODefine.nativeString(name));
        if (this.handle == -1L) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.fileSize = NativeIO.getLength(this.handle);
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.handle > -1L) {
            NativeIO.close(this.handle);
            this.handle = -1L;
            this.position = 0;
            this.length = -1;
            this.fileSize = -1L;
            this.allPos = -1L;
        }
    }

    public int available() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return (int)(this.fileSize - this.allPos & Integer.MAX_VALUE);
    }

    public int read() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.length <= -1) {
            return -1;
        }
        if (this.position >= this.length) {
            this.length = NativeIO.read(this.handle, -1L, this.temp, 0, 4096);
            this.position = 0;
            if (this.length <= 0) {
                this.length = -1;
                return -1;
            }
        }
        int ret = this.temp[this.position] & 0xFF;
        ++this.position;
        ++this.allPos;
        return ret;
    }

    public boolean markSupported() {
        return false;
    }
}

