/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.nativeio;

import java.io.IOException;
import org.maachang.util.nativeio.NativeIO;
import org.maachang.util.nativeio.NativeIODefine;
import org.maachang.util.nativeio.RandomIO;

class NativeRandomIO
implements RandomIO {
    private long handle = -1L;
    private String name = null;

    private NativeRandomIO() {
    }

    public NativeRandomIO(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        long handle = NativeIO.open(1, 2, NativeIODefine.nativeString(name = NativeIODefine.fullPath(name)));
        if (handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.handle = handle;
        this.name = name;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        if (this.isOpen()) {
            NativeIO.close(this.handle);
        }
        this.handle = -1L;
        this.name = null;
    }

    public int read(byte[] binary, long seek, int offset, int length) throws Exception {
        if (binary == null || binary.length <= 0 || seek <= -1L && offset <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int n = length = length <= 0 ? binary.length - offset : length;
        if (length <= 0 || length > binary.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return NativeIO.read(this.handle, seek, binary, offset, length);
    }

    public void write(byte[] binary, long seek, int offset, int length) throws Exception {
        if (binary == null || binary.length <= 0 || seek <= -1L && offset <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int n = length = length <= 0 ? binary.length - offset : length;
        if (length <= 0 || length > binary.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (NativeIO.write(this.handle, seek, binary, offset, length) <= -1) {
            throw new IOException("\u66f8\u8fbc\u307f\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public long length() throws Exception {
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.getLength(this.handle);
    }

    public void length(long length) throws Exception {
        if (length <= -1L) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        NativeIO.setLength(this.handle, length);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return 0;
    }

    public boolean isOpen() {
        return this.name != null;
    }
}

