/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.maachang.util.Os;
import org.maachang.util.RunProcess;
import org.maachang.util.net.NetAdapter;
import org.maachang.util.net.NetAdapterElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNetAdapter
implements NetAdapter {
    protected static final String DEFAULT_ETHER_NAME = "lo";
    protected static final String LO_HOST_SUB = "255.0.0.0";
    protected static final String LOCAL_IP = "127.0.0.1";
    protected Map<String, NetAdapterElement> table = null;

    AbstractNetAdapter() {
    }

    protected void init() {
        this.table = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public abstract void load() throws Exception;

    protected final void put(String name, NetAdapterElement element) {
        if (name == null || element == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.table.put(name, element);
    }

    @Override
    public NetAdapterElement get(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        return this.table.get(name);
    }

    @Override
    public Iterator iterator() {
        return this.table.keySet().iterator();
    }

    @Override
    public int size() {
        return this.table.size();
    }

    public String toString() {
        if (this.table == null) {
            return "null";
        }
        boolean cnt = false;
        StringBuilder buf = new StringBuilder();
        Iterator<String> it = this.table.keySet().iterator();
        while (it.hasNext()) {
            if (cnt) {
                buf.append(",");
            }
            String key = it.next();
            NetAdapterElement em = this.table.get(key);
            buf.append("ethName:").append(key).append(" {").append(em.toString()).append(" } ");
        }
        return buf.toString();
    }

    protected void setIpAddress(String name, String value) {
        if (name == null || (name = name.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        NetAdapterElement em = this.table.get(name);
        if (em == null) {
            em = new NetAdapterElement();
            this.table.put(name, em);
        }
        em.setAddr(value);
    }

    protected void setSubnetMask(String name, String value) {
        if (name == null || (name = name.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        NetAdapterElement em = this.table.get(name);
        if (em == null) {
            em = new NetAdapterElement();
            this.table.put(name, em);
        }
        em.setNetMask(value);
    }

    protected void setMacAddress(String name, String value) {
        if (name == null || (name = name.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        NetAdapterElement em = this.table.get(name);
        if (em == null) {
            em = new NetAdapterElement();
            this.table.put(name, em);
        }
        em.setMacAddr(value);
    }

    protected static List<String> runExec(String exec) throws Exception {
        String[] cmd;
        if (exec == null || (exec = exec.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        switch (Os.getInstance().getOS()) {
            case 33: {
                cmd = new String[]{"cmd", "/c", exec};
                break;
            }
            case 1: 
            case 66: {
                cmd = new String[]{"/bin/sh", "-c", exec};
                break;
            }
            default: {
                throw new IOException("\u5b9f\u884c\u4e2d\u306eOS\u3067\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        RunProcess runProc = new RunProcess(cmd);
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(runProc.execution()));
            while ((s = reader.readLine()) != null) {
                ret.add(s);
            }
            runProc.waitFor();
        }
        finally {
            runProc.destroy();
        }
        return ret;
    }

    protected static final byte[] convertString16ToBinary(String code) throws Exception {
        char[] cnv = null;
        byte[] ret = null;
        int[] tmp = null;
        try {
            int len = code.length();
            if (len % 2 == 1) {
                throw new IllegalArgumentException("\u6307\u5b9a\u6587\u5b57\u9577\u306f\u3001\u5947\u6570\u3067\u306f\u5bfe\u5fdc\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            code.toUpperCase();
            ret = new byte[len /= 2];
            cnv = new char[2];
            tmp = new int[2];
            int i = 0;
            int j = 0;
            while (i < len) {
                cnv[0] = code.charAt(j);
                cnv[1] = code.charAt(j + 1);
                int n = cnv[0] >= '0' && cnv[0] <= '9' ? cnv[0] - 48 : (cnv[0] >= 'A' && cnv[0] <= 'F' ? cnv[0] - 65 + 10 : (tmp[0] = cnv[0] >= 'a' && cnv[0] <= 'f' ? cnv[0] - 97 + 10 : -1));
                int n2 = cnv[1] >= '0' && cnv[1] <= '9' ? cnv[1] - 48 : (cnv[1] >= 'A' && cnv[1] <= 'F' ? cnv[1] - 65 + 10 : (tmp[1] = cnv[1] >= 'a' && cnv[1] <= 'f' ? cnv[1] - 97 + 10 : -1));
                if (tmp[0] == -1 || tmp[1] == -1) {
                    throw new IOException("\u6307\u5b9a\u5f15\u6570\u306f\u3001\u6570\u5024(16\u9032\u6570)\u4ee5\u5916\u306e\u60c5\u5831\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
                }
                ret[i] = (byte)(tmp[1] & 0xF | (tmp[0] & 0xF) << 4);
                ++i;
                j += 2;
            }
        }
        finally {
            cnv = null;
            tmp = null;
        }
        return ret;
    }
}

