/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.io.IOException;
import java.util.Locale;
import org.maachang.util.Os;
import org.maachang.util.net.NetAdapter;
import org.maachang.util.net.NetAdapterByBsd;
import org.maachang.util.net.NetAdapterByLinux;
import org.maachang.util.net.NetAdapterByWinNT;

public abstract class NetAdapterFactory {
    public static final NetAdapter get() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        switch (Os.getInstance().getOS()) {
            case 33: {
                return new NetAdapterByWinNT();
            }
            case 1: {
                if (osName.indexOf("linux") != -1) {
                    return new NetAdapterByLinux();
                }
                return new NetAdapterByBsd();
            }
            case 66: {
                return new NetAdapterByBsd();
            }
        }
        throw new IOException("\u5b9f\u884c\u4e2d\u306eOS\u3067\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
    }

    public static final void main(String[] args) throws Exception {
        NetAdapter ad = NetAdapterFactory.get();
        ad.load();
        System.out.println(ad);
    }
}

