/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import org.maachang.comet.httpd.engine.HttpdEngine;
import org.maachang.comet.net.NetService;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.manager.GlobalManager;
import org.maachang.rawio.Cpu;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicDOUBLE;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;

public class MSystem {
    private static final long NEXT_TIME = 3000L;
    private final AtomicDOUBLE useCpu = new AtomicDOUBLE(0.0);
    private final AtomicINT processId = new AtomicINT(-1);
    private final AtomicBOOL processIdFlag = new AtomicBOOL(false);
    private final AtomicLONG next = new AtomicLONG(-1L);
    private static final MSystem SNGL = new MSystem();

    private static final NetService netService() {
        return ((HttpdEngine)GlobalManager.getInstance().get("HTTPD")).getNetService();
    }

    private static final RecordFactory recordFactory() {
        return (RecordFactory)GlobalManager.getInstance().get("DBMS_POOL");
    }

    public static int getNetUsePooling() {
        return MSystem.netService().getNioService().getUsePooling();
    }

    public static int getNetActivePooling() {
        return MSystem.netService().getNioService().getActivePooling();
    }

    public static int getDbMax() {
        return MSystem.recordFactory().getConnectionManager().getMax();
    }

    public static int getDbActives() {
        return MSystem.recordFactory().getConnectionManager().getActives();
    }

    public static int getDbIdle() {
        return MSystem.recordFactory().getConnectionManager().getIdle();
    }

    public static final double useCpu() {
        return MSystem.getInstance()._useCpu();
    }

    public static final int getProcessId() {
        return MSystem.getInstance()._getProcessId();
    }

    protected static final MSystem getInstance() {
        return SNGL;
    }

    private int _getProcessId() {
        if (this.processIdFlag.get()) {
            return this.processId.get();
        }
        this.processId.set(Cpu.getProcessId());
        this.processIdFlag.set(true);
        return this.processId.get();
    }

    private double _useCpu() {
        long t = System.currentTimeMillis();
        if (t >= this.next.get() + 3000L) {
            this.useCpu.set(Cpu.useCpu());
            this.next.set(t);
        }
        return this.useCpu.get();
    }
}

