/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

public class BaseConfig {
    private static final String BASE_SECTION = "base-config";
    private static final String CHARSET = "UTF8";
    private static final String READ_FILE = "conf/base.conf";
    private static final String USERS_MANAGER = "users";
    private static final String DB_USERS_MANAGER = "dbusers";
    private static final String MIME_MANAGER = "mime";
    private static final String MAIL_MANAGER = "mail";
    private static final String PACKAGES_MANAGER = "packages";
    private static final String CONFIG_MANAGER = "config";
    private Config iniParams = null;
    private String fileName = null;

    public synchronized void open() throws Exception {
        this.open(READ_FILE);
    }

    public synchronized void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public synchronized void close() {
        this.iniParams = null;
        this.fileName = null;
    }

    public String getUsers() {
        return this.iniParams.get(BASE_SECTION, USERS_MANAGER, 0);
    }

    public String getDbUsers() {
        return this.iniParams.get(BASE_SECTION, DB_USERS_MANAGER, 0);
    }

    public String getMimes() {
        return this.iniParams.get(BASE_SECTION, MIME_MANAGER, 0);
    }

    public String getMail() {
        return this.iniParams.get(BASE_SECTION, MAIL_MANAGER, 0);
    }

    public String getPackages() {
        return this.iniParams.get(BASE_SECTION, PACKAGES_MANAGER, 0);
    }

    public String getConfig(int no) {
        return this.iniParams.get(BASE_SECTION, CONFIG_MANAGER, no);
    }

    public int size() {
        return this.iniParams.size(BASE_SECTION, CONFIG_MANAGER);
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                this.iniParams = iniParams;
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

