/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicOBJECT;

public class IniFile {
    private static final String CHARSET = "UTF8";
    private final AtomicOBJECT<Config> iniParams = new AtomicOBJECT();

    public IniFile() {
        this.close();
    }

    public void open(String name) throws Exception {
        this.close();
        this.addOpen(name, "");
    }

    public void open(String name, String header) throws Exception {
        this.close();
        this.addOpen(name, header);
    }

    public void addOpen(String name) throws Exception {
        this.addOpen(name, "");
    }

    public void addOpen(String name, String header) throws Exception {
        String fullPath = FileUtil.getFullPath((String)name);
        BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullPath), CHARSET));
        try {
            try {
                Config c = (Config)this.iniParams.get();
                ReadIni.analisys((Config)c, (String)header, (BufferedReader)buf);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
        }
    }

    public void close() {
        this.iniParams.set((Object)new Config());
    }

    public String[] getAll(String section, String key) {
        return ((Config)this.iniParams.get()).getAll(section, key);
    }

    public String get(String section, String key, int no) {
        return ((Config)this.iniParams.get()).get(section, key, no);
    }

    public Integer getNumber(String section, String key, int no) {
        String p = ((Config)this.iniParams.get()).get(section, key, no);
        if (p == null || p.length() <= 0) {
            return null;
        }
        Integer ret = null;
        try {
            ret = new Integer(p);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public Double getFloat(String section, String key, int no) {
        String p = ((Config)this.iniParams.get()).get(section, key, no);
        if (p == null || p.length() <= 0) {
            return null;
        }
        Double ret = null;
        try {
            ret = new Double(p);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public Boolean getBoolean(String section, String key, int no) {
        String p = ((Config)this.iniParams.get()).get(section, key, no);
        if (p == null || p.length() <= 0) {
            return null;
        }
        Boolean ret = null;
        try {
            ret = new Boolean(p);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public int size(String section, String key) {
        return ((Config)this.iniParams.get()).size(section, key);
    }

    public int size() {
        return ((Config)this.iniParams.get()).size();
    }

    public Config getConfig() {
        return (Config)this.iniParams.get();
    }

    public String toString() {
        if (this.iniParams.get() != null) {
            return ((Config)this.iniParams.get()).toString();
        }
        return "null";
    }
}

