/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.State;
import org.maachang.comet.conf.HttpdAccessConfig;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.HttpdDef;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.HttpdUtil;
import org.maachang.comet.httpd.engine.WriteError;
import org.maachang.comet.httpd.engine.auth.HttpdAuthBasic;
import org.maachang.comet.httpd.engine.auth.HttpdAuthDigest;
import org.maachang.comet.httpd.engine.auth.HttpdAuthElement;
import org.maachang.comet.httpd.engine.auth.HttpdAuthManager;
import org.maachang.comet.httpd.engine.auth.HttpdAuthUsers;
import org.maachang.comet.httpd.engine.script.BaseScriptException;
import org.maachang.comet.net.HttpReceiveCallback;
import org.maachang.comet.net.HttpdHeadersImpl;
import org.maachang.comet.net.HttpdRequestImpl;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.conf.ConvIniParam;
import org.maachang.manager.GlobalManager;

class HttpdExecutionReceive
implements HttpReceiveCallback {
    private static final Log LOG = LogFactory.getLog(HttpdExecutionReceive.class);
    private HttpdAccessConfig accessControll = new HttpdAccessConfig();

    public HttpdExecutionReceive() {
        try {
            this.accessControll.open();
        }
        catch (Exception e) {
            LOG.error((Object)"\u30a2\u30af\u30bb\u30b9\u30b3\u30f3\u30d5\u30a3\u30b0\u30aa\u30fc\u30d7\u30f3\u30a8\u30e9\u30fc", (Throwable)e);
        }
    }

    public void execution(ConnectionInfo conn, int seqId, HttpdRequest request, HttpdResponse response) throws Exception {
        if (conn == null || !conn.isUse()) {
            return;
        }
        try {
            this.addRequestURLByDirector(request);
            ((HttpdRequestImpl)request).setRemote(conn.getInetAddress().getHostAddress(), conn.getPort());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("id:" + seqId + "[" + request.getRemoteAddress() + ":" + request.getRemotePort() + "]-" + "(" + request.getMethod() + ")-url:" + request.getUrlPath() + " [" + request.getHeader().getHeader("User-Agent") + "]"));
            }
            HttpdExecutionReceive.putGzip(request);
            int nowState = State.getInstance().state();
            if (nowState != 1) {
                if (nowState == 3) {
                    try {
                        WriteError.output(request, response, null, 500, "\u305f\u3060\u3044\u307e\u3001\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u4e2d\u3067\u3059.");
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        WriteError.output(request, response, null, 503, "\u505c\u6b62\u4e2d...\u30b5\u30fc\u30d0\u30b9\u30c6\u30fc\u30bf\u30b9(state:" + State.getInstance().toString(nowState) + ").");
                    }
                    catch (Exception exception) {}
                }
            } else if (!HttpdDef.isSeePath(request.getUrlPath())) {
                try {
                    WriteError.output(request, response, null, 403, "\u6307\u5b9aURL\u306f\u4e0d\u6b63\u3067\u3059");
                }
                catch (Exception exception) {}
            } else if (!this.accessControll.isMask(request.getUrlPath(), request.getRemoteAddress())) {
                LOG.warn((Object)("id:" + seqId + "\u30a2\u30af\u30bb\u30b9\u9055\u53cd\u3092\u691c\u77e5"));
                WriteError.output(request, response, null, 403, "\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            } else {
                String method = request.getMethod();
                if ("GET".equals(method) || "POST".equals(method)) {
                    this.execPostOrGet(method, request, response, seqId);
                } else {
                    this.execNotPostAndGet(method, request, response);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"error", (Throwable)e);
            if (conn != null) {
                conn.destroy();
            }
            throw e;
        }
        catch (Error er) {
            LOG.warn((Object)"error", (Throwable)er);
            if (conn != null) {
                conn.destroy();
            }
            throw er;
        }
    }

    private void execNotPostAndGet(String method, HttpdRequest request, HttpdResponse response) throws Exception {
        if ("HEAD".equals(method)) {
            this.executionHead(request, response);
        } else if ("OPTIONS".equals(method)) {
            this.executionOptions(request, response);
        } else {
            this.executionNoSupprtMethd(request, response);
        }
        this.closeConnection(request.getConnectionInfo());
    }

    private void executionHead(HttpdRequest request, HttpdResponse response) throws Exception {
        int state = -1;
        String authHeader = null;
        HttpdAuthManager auth = (HttpdAuthManager)GlobalManager.getValue((String)"AUTH_MANAGER");
        HttpdAuthElement emt = null;
        if (auth != null && (emt = auth.getElement(request.getUrlPath())) != null) {
            HttpdAuthUsers users = (HttpdAuthUsers)GlobalManager.getValue((String)"USERS_MANAGER");
            if (emt.getAuthType() == 0) {
                if (!HttpdAuthBasic.isAuth(request, emt, users, request.getHeader())) {
                    authHeader = HttpdAuthBasic.getSendAuth(emt);
                    state = 401;
                }
            } else if (emt.getAuthType() == 1 && !HttpdAuthDigest.isAuth(request, emt, users, request.getHeader())) {
                authHeader = HttpdAuthDigest.getSendAuth(emt);
                state = 401;
            }
        }
        long last = -1L;
        if (state == -1) {
            boolean pub = false;
            boolean sc = false;
            HttpdExecutionManager pubMan = (HttpdExecutionManager)GlobalManager.getValue((String)"PUBLIC_PAGE_MANAGER");
            HttpdExecutionManager scMan = (HttpdExecutionManager)GlobalManager.getValue((String)"APPLICATION_PAGE_MANAGER");
            last = pubMan.getFileTime(request.getUrlPath());
            if (last == -1L) {
                last = scMan.getFileTime(request.getUrlPath());
                if (last != -1L) {
                    sc = true;
                }
            } else {
                pub = true;
            }
            if (last == -1L) {
                state = 404;
            }
            if (pub && !pubMan.isRead(request.getUrlPath()) || sc && !scMan.isRead(request.getUrlPath())) {
                state = 403;
            } else {
                state = 200;
                if (HttpdUtil.isClientCache(request.getHeader(), last)) {
                    state = 304;
                }
            }
        }
        HttpdHeadersImpl header = null;
        if (authHeader != null) {
            header = new HttpdHeadersImpl();
            header.addHeader("WWW-Authenticate", authHeader);
        }
        this.returnHeader(request, response, state, last, -1L, -1, header);
    }

    private void executionOptions(HttpdRequest request, HttpdResponse response) throws Exception {
        HttpdResponse res = response.create(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
        res.flushAndClose();
    }

    private void executionNoSupprtMethd(HttpdRequest request, HttpdResponse response) throws Exception {
        WriteError.output(request, response, null, 501, null);
    }

    private void execPostOrGet(String method, HttpdRequest request, HttpdResponse response, int seqId) throws Exception {
        try {
            this.executionTargetURL(request, response);
        }
        catch (BaseScriptException se) {
            ScriptException sc = se.getScriptException();
            LOG.error((Object)("## error(id:" + seqId + ")-(url:" + request.getUrlPath() + ")"), (Throwable)sc);
            StringBuilder buf = new StringBuilder();
            buf.append(sc.getMessage()).append("<BR><BR>");
            if (se.getErrorScriptInfo() != null) {
                buf.append(se.getErrorScriptInfo());
            }
            String msg = buf.toString();
            buf = null;
            try {
                WriteError.output(request, response, null, 500, msg);
            }
            catch (Exception exception) {}
        }
        catch (HttpdStateException hs) {
            if (hs.getState() >= 500) {
                if (request != null) {
                    LOG.error((Object)("url:(id:" + seqId + "):" + request.getUrlPath() + " - status(" + hs.getState() + ") error"), (Throwable)hs);
                }
            } else if (request != null) {
                LOG.warn((Object)("url:(id:" + seqId + ")" + request.getUrlPath() + " - status(" + hs.getState() + ") warning"), (Throwable)hs);
            }
            try {
                WriteError.output(request, response, null, hs.getState(), hs.getErrorMessage());
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            LOG.error((Object)("error(id:" + seqId + "):"), (Throwable)e);
            try {
                WriteError.output(request, response, null, 500, e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void executionTargetURL(HttpdRequest request, HttpdResponse response) throws Exception {
        try {
            boolean pub = false;
            boolean sc = false;
            HttpdExecutionManager pubMan = (HttpdExecutionManager)GlobalManager.getValue((String)"PUBLIC_PAGE_MANAGER");
            HttpdExecutionManager scMan = (HttpdExecutionManager)GlobalManager.getValue((String)"APPLICATION_PAGE_MANAGER");
            String path = request.getUrlPath();
            if (pubMan.isPath(path) && !path.endsWith(".ms")) {
                pub = true;
            } else if (scMan.isPath(path)) {
                sc = true;
            } else {
                throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            HttpdExecutionManager man = null;
            if (pub && pubMan.isRead(path)) {
                man = pubMan;
            } else if (sc && scMan.isRead(path)) {
                if (this.isAuth(request, response)) {
                    return;
                }
                man = scMan;
            } else {
                throw new HttpdStateException(403);
            }
            long last = man.getFileTime(path);
            if (HttpdUtil.isClientCache(request.getHeader(), last)) {
                this.returnHeader(request, response, 304, last, request.getKeepAliveTimeout(), request.getKeepAliveCount(), null);
            } else {
                man.get(request, response);
            }
        }
        finally {
            if (response.isOutputStream() || response.getState() != 200) {
                response.flushAndClose();
            } else {
                response.clear();
            }
        }
    }

    private void returnHeader(HttpdRequest request, HttpdResponse response, int state, long date, long timeout, int count, HttpdHeaders header) throws Exception {
        HttpdResponse res = response.create(request, request.getUrlPath(), state, request.getKeepAliveTimeout(), request.getKeepAliveCount());
        if (date == -1L) {
            res.getHeader().setHeader("Date", HttpdTimestamp.getTimestamp(0L));
        } else {
            res.getHeader().setHeader("Date", HttpdTimestamp.getTimestamp(date));
        }
        res.getHeader().setHeader("Content-Length", String.valueOf(0));
        res.setHttpClose(false);
        res.getHeader().add(header);
        res.flushAndClose();
    }

    private boolean isAuth(HttpdRequest request, HttpdResponse response) throws Exception {
        String authHeader = null;
        HttpdAuthManager auth = (HttpdAuthManager)GlobalManager.getValue((String)"AUTH_MANAGER");
        HttpdAuthElement emt = null;
        if (auth != null && (emt = auth.getElement(request.getUrlPath())) != null) {
            HttpdAuthUsers users = (HttpdAuthUsers)GlobalManager.getValue((String)"USERS_MANAGER");
            if (emt.getAuthType() == 0) {
                if (!HttpdAuthBasic.isAuth(request, emt, users, request.getHeader())) {
                    authHeader = HttpdAuthBasic.getSendAuth(emt);
                }
            } else if (emt.getAuthType() == 1 && !HttpdAuthDigest.isAuth(request, emt, users, request.getHeader())) {
                authHeader = HttpdAuthDigest.getSendAuth(emt);
            }
        }
        if (authHeader != null) {
            HttpdHeadersImpl addHeader = new HttpdHeadersImpl();
            addHeader.addHeader("WWW-Authenticate", authHeader);
            WriteError.output(request, response, addHeader, 401, null);
            return true;
        }
        return false;
    }

    private static final void putGzip(HttpdRequest req) {
        IniFile config = (IniFile)GlobalManager.getValue((String)"CONFIG_MANAGER");
        boolean flag = ConvIniParam.getBoolean((String)config.get("server", "gzip", 0));
        req.setGzip(flag);
    }

    private void closeConnection(ConnectionInfo conn) {
        if (conn != null) {
            conn.destroy();
        }
    }

    private void addRequestURLByDirector(HttpdRequest request) throws Exception {
        String path = request.getUrlPath();
        if (path.endsWith("/")) {
            return;
        }
        HttpdExecutionManager man = (HttpdExecutionManager)GlobalManager.getValue((String)"PUBLIC_PAGE_MANAGER");
        if (man.isDirectory(path)) {
            request.setUrlPath(String.valueOf(path) + "/");
            return;
        }
        man = (HttpdExecutionManager)GlobalManager.getValue((String)"APPLICATION_PAGE_MANAGER");
        if (man.isDirectory(path)) {
            request.setUrlPath(String.valueOf(path) + "/");
            return;
        }
    }
}

