/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.EnvJavascript;
import org.maachang.comet.httpd.engine.HttpdDef;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.PublicCache;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;
import org.maachang.util.nativeio.NativeIOInstance;

class HttpdPublicManager
implements HttpdExecutionManager {
    private static final long NOT_GZIP_LENGTH = 1024L;
    private static final long ONE_WRITE_BY_LENGTH = 8192L;
    private String publicDirectory = null;

    private HttpdPublicManager() {
    }

    public HttpdPublicManager(String currentDirectory) throws Exception {
        this.publicDirectory = ScriptDef.trimCurrentDirectory(currentDirectory) + "public/";
    }

    protected void finalize() throws Exception {
        this.publicDirectory = null;
    }

    public void get(HttpdRequest request, HttpdResponse response) throws Exception {
        block39: {
            try {
                String path = this.getUsePath(request.getUrlPath());
                this.pushUrl(request, path);
                if (HttpdPublicManager.isJsOrCssOrIco(path)) {
                    byte[] data = PublicCache.getInstance().getData(path);
                    if (data == null) break block39;
                    long time = PublicCache.getInstance().getLastTime(path);
                    response.create(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                    response.setCookieSession(request);
                    response.getHeader().setHeader("Last-Modified", HttpdTimestamp.getTimestamp(time));
                    response.setHttpClose(false);
                    if (path.toLowerCase().endsWith(".js")) {
                        String js = new String(data, "UTF8");
                        js = EnvJavascript.convert(request, js);
                        data = js.getBytes("UTF8");
                        js = null;
                    }
                    response.getHeader().setHeader("Content-Length", String.valueOf(data.length));
                    if ((long)data.length < 1024L) {
                        response.setGzip(false);
                    }
                    OutputStream out = null;
                    try {
                        out = response.getOutput();
                        out.write(data);
                        out.flush();
                        out.close();
                        out = null;
                        break block39;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                response.create(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                response.setCookieSession(request);
                response.getHeader().setHeader("Last-Modified", HttpdTimestamp.getTimestamp(FileUtil.getLastTime((String)path)));
                long flen = FileUtil.getLength((String)path);
                response.getHeader().setHeader("Content-Length", String.valueOf(flen));
                response.setHttpClose(false);
                if (flen < 1024L) {
                    response.setGzip(false);
                }
                if (flen >= 8192L) {
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        in = NativeIOInstance.inputStream((String)path);
                        out = response.getOutput();
                        byte[] bin = new byte[1024];
                        while (true) {
                            int len;
                            if ((len = in.read(bin)) <= 0) {
                                if (len > -1) continue;
                                break;
                            }
                            out.write(bin, 0, len);
                        }
                        out.flush();
                        out.close();
                        out = null;
                        in.close();
                        in = null;
                        break block39;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                OutputStream out = null;
                try {
                    out = response.getOutput();
                    out.write(FileUtil.getFile((String)path));
                    out.flush();
                    out.close();
                    out = null;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    out = null;
                }
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
        }
    }

    public long getFileTime(String path) {
        if (HttpdPublicManager.isJsOrCssOrIco(path = this.getUsePath(path))) {
            try {
                return PublicCache.getInstance().getLastTime(path);
            }
            catch (Exception exception) {
            }
        } else if (FileUtil.isFileExists((String)path) && FileUtil.isRead((String)path)) {
            return FileUtil.getLastTime((String)path);
        }
        return -1L;
    }

    public boolean isPath(String path) {
        if (HttpdPublicManager.isJsOrCssOrIco(path = this.getUsePath(path))) {
            try {
                return PublicCache.getInstance().getLastTime(path) > 0L;
            }
            catch (Exception exception) {
            }
        } else if (FileUtil.isFileExists((String)path)) {
            return true;
        }
        return false;
    }

    public boolean isDirectory(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return FileUtil.isDirExists((String)(path = String.valueOf(this.publicDirectory) + path));
    }

    public boolean isRead(String path) {
        if (HttpdPublicManager.isJsOrCssOrIco(path = this.getUsePath(path))) {
            boolean ret = false;
            try {
                ret = PublicCache.getInstance().getLastTime(path) > 0L;
            }
            catch (Exception e) {
                ret = false;
            }
            return ret;
        }
        if (FileUtil.isFileExists((String)path)) {
            return FileUtil.isRead((String)path);
        }
        return false;
    }

    private final String getUsePath(String path) {
        if ("/favicon.ico".endsWith(path)) {
            path = String.valueOf(this.publicDirectory) + "img/" + "/favicon.ico".substring(1, "/favicon.ico".length());
            if (!FileUtil.isFileExists((String)path)) {
                path = this.publicDirectory + "/favicon.ico".substring(1, "/favicon.ico".length());
            }
        } else {
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            if ((path = String.valueOf(this.publicDirectory) + path).endsWith("/")) {
                int len = HttpdDef.INDEX_HTML.length;
                int i = 0;
                while (i < len) {
                    String ph = String.valueOf(path) + HttpdDef.INDEX_HTML[i];
                    if (FileUtil.isFileExists((String)ph)) {
                        path = ph;
                        break;
                    }
                    ++i;
                }
            }
        }
        return path;
    }

    private final void pushUrl(HttpdRequest request, String path) throws Exception {
        String str = FileUtil.getFullPath((String)"public/");
        path = FileUtil.getFullPath((String)path);
        path = path.substring(str.length(), path.length());
        if (!(path = StringUtil.changeString((String)path, (String)"\\", (String)"/")).startsWith("/")) {
            path = "/" + path;
        }
        request.setUrlPath(path);
    }

    private static final boolean isJsOrCssOrIco(String path) {
        return (path = path.toLowerCase()).endsWith(".js") || path.endsWith(".css") || path.endsWith(".ico");
    }
}

