/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.auth;

import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpdAuthElement {
    public static final int AUTH_BY_BASIC = 0;
    public static final int AUTH_BY_DIGEST = 1;
    private String realm = null;
    private int authType = -1;
    private String targetDirectory = null;
    private long fileTime = -1L;
    private HashSet<String> users = null;

    protected void finalize() throws Exception {
        this.clear();
        this.users = null;
    }

    public synchronized void create(String realm, int authType, String targetDirectory, long fileTime) throws Exception {
        if (realm == null || (realm = realm.trim()).length() <= 0 || targetDirectory == null || (targetDirectory = targetDirectory.trim()).length() <= 0 || authType != 0 && authType != 1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059[realm:" + realm + " authType:" + authType + " targetDirectory:" + targetDirectory + "]");
        }
        this.realm = realm;
        this.authType = authType;
        this.targetDirectory = targetDirectory;
        this.fileTime = fileTime;
        this.users = new HashSet();
    }

    public synchronized void clear() {
        this.realm = null;
        this.authType = -1;
        this.targetDirectory = null;
        this.fileTime = -1L;
        this.users.clear();
    }

    public synchronized void addUser(String user) {
        if (user == null || (user = user.trim()).length() <= 0) {
            return;
        }
        this.users.add(user);
    }

    public synchronized String getRealm() {
        return this.realm;
    }

    public synchronized int getAuthType() {
        return this.authType;
    }

    public synchronized String getAuthTypeByString() {
        switch (this.authType) {
            case 0: {
                return "BASIC";
            }
            case 1: {
                return "DIGEST";
            }
        }
        return "UNKNOWN";
    }

    public synchronized String getTargetDirectory() {
        return this.targetDirectory;
    }

    public synchronized long getFileTime() {
        return this.fileTime;
    }

    public synchronized HashSet<String> getUsers() {
        return this.users;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("realm:").append(this.getRealm()).append(" auth_type:").append(this.getAuthTypeByString());
        buf.append(" users:");
        if (this.users != null && this.users.size() > 0) {
            Object[] objs = this.users.toArray();
            int len = objs.length;
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append((String)objs[i]);
                ++i;
            }
        }
        return buf.toString();
    }
}

