/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.auth;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.HttpdUtil;
import org.maachang.comet.httpd.engine.auth.HttpdAuthElement;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;
import org.maachang.util.atomic.AtomicOBJECT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpdAuthManager {
    private static final String AUTH_FILE = "$auth-file";
    private final AtomicOBJECT<String> basePath = new AtomicOBJECT();
    private final Map<String, HttpdAuthElement> manager = new ConcurrentHashMap<String, HttpdAuthElement>();
    private static final String PARAM_REALM = "realm";
    private static final String PARAM_AUTH_TYPE = "auth";
    private static final String PARAM_AUTH_USERS = "users";

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(String basePath) throws Exception {
        if (basePath == null || (basePath = basePath.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isDirExists((String)basePath)) {
            throw new IOException("\u6307\u5b9a\u30d1\u30b9[" + basePath + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (!(basePath = FileUtil.getFullPath((String)basePath)).endsWith("/") && !basePath.endsWith("\\")) {
            basePath = String.valueOf(basePath) + FileUtil.FILE_SPACE;
        }
        this.basePath.set((Object)basePath);
    }

    public void clear() {
        this.manager.clear();
        this.basePath.set(null);
    }

    public HttpdAuthElement getElement(String path) throws Exception {
        int p;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith("/") && (p = path.lastIndexOf("/")) > 0) {
            path = path.substring(0, p + 1);
        }
        return HttpdAuthManager.getByNextElement(this.manager, (String)this.basePath.get(), path);
    }

    public static final void setSuccessAuth(HttpdRequest request, String user, String passwd) {
        HttpdParams params = request.getQuery();
        params.addParam("_success_auth_user", user);
        params.addParam("_success_auth_passwd", passwd == null ? "" : passwd);
    }

    private static final String beforePath(String path) {
        int p;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((p = path.lastIndexOf("/")) >= 0) {
            path = path.substring(0, p + 1);
            return path;
        }
        return null;
    }

    private static final HttpdAuthElement getByNextElement(Map<String, HttpdAuthElement> map, String basePath, String path) throws Exception {
        String readAuthFile = HttpdUtil.convertFullPath(basePath, path) + AUTH_FILE;
        HttpdAuthElement em = map.get(path);
        if (em != null) {
            if (FileUtil.isFileExists((String)readAuthFile)) {
                if (em.getFileTime() != FileUtil.getLastTime((String)readAuthFile) && (em = HttpdAuthManager.createAuthElement(readAuthFile, path)) != null) {
                    map.put(path, em);
                }
            } else {
                map.remove(path);
                em = null;
            }
        } else if (FileUtil.isFileExists((String)readAuthFile) && (em = HttpdAuthManager.createAuthElement(readAuthFile, path)) != null) {
            map.put(path, em);
        }
        if (em != null) {
            return em;
        }
        String before = HttpdAuthManager.beforePath(path);
        if (before == null) {
            return null;
        }
        readAuthFile = null;
        em = null;
        return HttpdAuthManager.getByNextElement(map, basePath, before);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final HttpdAuthElement createAuthElement(String path, String targetPath) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF8"));
            boolean newFlag = false;
            int pattern = -1;
            int befPattern = -1;
            int firstPos = -1;
            int valuePos = -1;
            StringBuilder buf = null;
            String[] values = new String[3];
            while (true) {
                int pp;
                String oneLine;
                if ((oneLine = br.readLine()) == null) {
                    if (buf == null) break;
                    HttpdAuthManager.paramByValue(values, pattern, buf.toString(), null, firstPos, valuePos);
                    break;
                }
                if ((oneLine = oneLine.trim()).length() <= 0) continue;
                String lowLine = oneLine.toLowerCase();
                int p = lowLine.indexOf(PARAM_REALM);
                if (p != -1 && (pp = lowLine.indexOf(":", p + PARAM_REALM.length())) != -1) {
                    befPattern = pattern;
                    pattern = 0;
                    firstPos = p;
                    valuePos = pp + 1;
                    newFlag = true;
                }
                if ((p = lowLine.indexOf(PARAM_AUTH_TYPE)) != -1 && (pp = lowLine.indexOf(":", p + PARAM_AUTH_TYPE.length())) != -1) {
                    befPattern = pattern;
                    pattern = 1;
                    firstPos = p;
                    valuePos = pp + 1;
                    newFlag = true;
                }
                if ((p = lowLine.indexOf(PARAM_AUTH_USERS)) != -1 && (pp = lowLine.indexOf(":", p + PARAM_AUTH_USERS.length())) != -1) {
                    befPattern = pattern;
                    pattern = 2;
                    firstPos = p;
                    valuePos = pp + 1;
                    newFlag = true;
                }
                lowLine = null;
                if (newFlag) {
                    String str = null;
                    str = buf == null ? HttpdAuthManager.paramByValue(values, befPattern, null, oneLine, firstPos, valuePos) : HttpdAuthManager.paramByValue(values, befPattern, buf.toString(), oneLine, firstPos, valuePos);
                    buf = new StringBuilder();
                    if (str != null && str.length() > 0) {
                        buf.append(str);
                    }
                    newFlag = false;
                    continue;
                }
                if (pattern == -1) continue;
                if (buf == null) {
                    buf = new StringBuilder();
                }
                buf.append(oneLine);
            }
            HttpdAuthElement httpdAuthElement = HttpdAuthManager.convertElement(values, path, targetPath);
            return httpdAuthElement;
        }
        catch (Exception e) {
            HttpdAuthElement httpdAuthElement;
            block21: {
                httpdAuthElement = null;
                if (br == null) break block21;
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            br = null;
            return httpdAuthElement;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            br = null;
        }
    }

    private static final String paramByValue(String[] out, int pattern, String before, String thisData, int fpos, int vpos) {
        if (before == null || (before = before.trim()).length() <= 0 || pattern <= -1 || out.length <= pattern) {
            if (thisData != null) {
                return thisData.substring(vpos, thisData.length());
            }
            return null;
        }
        out[pattern] = before.trim();
        if (thisData != null) {
            return thisData.substring(vpos, thisData.length());
        }
        return null;
    }

    private static final HttpdAuthElement convertElement(String[] out, String path, String targetPath) throws Exception {
        ArrayList lst;
        if (out[0] == null || (out[0] = out[0].trim()).length() <= 0 || out[1] == null || (out[1] = out[1].trim()).length() <= 0) {
            return null;
        }
        HttpdAuthElement ret = new HttpdAuthElement();
        int authType = -1;
        String authTypeByString = out[1].toLowerCase();
        if (authTypeByString.equals("basic")) {
            authType = 0;
        } else if (authTypeByString.equals("digest")) {
            authType = 1;
        }
        ret.create(out[0], authType, targetPath, FileUtil.getLastTime((String)path));
        if (out[2] != null && (lst = StringUtil.cutString((String)out[2], (String)",\n\r")) != null && lst.size() > 0) {
            int len = lst.size();
            int i = 0;
            while (i < len) {
                ret.addUser((String)lst.get(i));
                ++i;
            }
        }
        return ret;
    }
}

