/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.comet.Comet;
import org.maachang.comet.httpd.engine.comet.CometMonitor;
import org.maachang.comet.httpd.engine.comet.ExecutionPoolComet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometManager {
    private static final Log LOG = LogFactory.getLog(CometManager.class);
    private Map<String, Comet> manager = new ConcurrentHashMap<String, Comet>();
    private ExecutionPoolComet pool = null;
    private CometMonitor monitor = null;

    public CometManager() {
        this.pool = new ExecutionPoolComet();
        this.monitor = new CometMonitor(this.manager);
    }

    public CometManager(int length) {
        this.pool = length > 0 ? new ExecutionPoolComet(length) : new ExecutionPoolComet();
        this.monitor = new CometMonitor(this.manager);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.clear();
        }
        if (this.manager != null && this.manager.size() > 0) {
            Iterator<String> it = this.manager.keySet().iterator();
            while (it.hasNext()) {
                Comet cmt = this.manager.get(it.next());
                if (cmt == null) continue;
                cmt.clear();
            }
            this.manager.clear();
        }
        if (this.monitor != null) {
            this.monitor.clear();
        }
        this.manager = null;
        this.pool = null;
        this.monitor = null;
    }

    public void cometRequest(HttpdRequest request) throws Exception {
        if (request == null || !request.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String groupId = request.getQuery().getParam("groupId");
        if (groupId == null) {
            throw new IOException("groupId\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Comet comet = null;
        String path = request.getUrlPath();
        comet = this.manager.get(groupId);
        if (comet == null) {
            comet = new Comet(groupId, path);
            this.manager.put(groupId, comet);
        }
        comet.putConnection(request);
    }

    public void execution(Object args, String groupId) throws Exception {
        Comet comet;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("executionComet...groupId:" + groupId));
        }
        if ((comet = this.comet(groupId)) != null) {
            this.pool.executionComet(comet, args, groupId);
        }
    }

    public Comet getComet(String groupId) {
        return this.comet(groupId);
    }

    public void getSessionIds(ArrayList<String> out, String groupId) {
        if (out == null) {
            return;
        }
        Comet comet = this.comet(groupId);
        if (comet != null) {
            comet.getConnectSessionIds(out);
        }
    }

    public int getConnectSize(String groupId) {
        Comet comet = this.comet(groupId);
        if (comet != null) {
            return comet.getConnectSize();
        }
        return 0;
    }

    public int getConnectCount() {
        int ret = 0;
        if (this.manager == null && this.manager.size() <= 0) {
            return 0;
        }
        Iterator<String> it = this.manager.keySet().iterator();
        while (it.hasNext()) {
            Comet cmt = this.manager.get(it.next());
            if (cmt == null) continue;
            ret += cmt.getConnectSize();
        }
        return ret;
    }

    public Iterator getGroupIterator() {
        Iterator<String> ret = null;
        if (this.manager != null) {
            ret = this.manager.keySet().iterator();
        }
        return ret;
    }

    public int size() {
        int ret = 0;
        if (this.manager != null) {
            ret = this.manager.size();
        }
        return ret;
    }

    public int getPoolSize() {
        return this.pool.size();
    }

    public boolean isComet(String groupId) {
        return this.comet(groupId) != null;
    }

    public boolean isUse() {
        return this.manager != null && this.pool != null && this.pool.isUse();
    }

    private synchronized Comet comet(String groupId) {
        Comet ret = null;
        if (this.manager != null) {
            ret = this.manager.get(groupId);
        }
        return ret;
    }
}

