/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.util.StringUtil;
import org.maachang.util.atomic.AtomicOBJECT;
import org.maachang.util.atomic.ReadAtomicList;

public class SrcScript {
    public static final String[] SPECIAL_SRC = new String[]{"<", ">"};
    public static final String[] SPECIAL_DEST = new String[]{"&lt;", "&gt;"};
    private final AtomicOBJECT<String[]> script = new AtomicOBJECT();
    private final ReadAtomicList lists = new ReadAtomicList();

    public SrcScript() {
        this.script.set(null);
        this.lists.clear();
    }

    public SrcScript(String script) throws Exception {
        this.create(script);
    }

    public synchronized void create(String script) throws Exception {
        if (script == null || (script = script.trim()).length() <= 0) {
            this.script.set((Object)new String[0]);
        } else {
            int i;
            String line;
            ArrayList<String> scs = new ArrayList<String>();
            BufferedReader sr = new BufferedReader(new StringReader(script));
            int len = SPECIAL_SRC.length;
            while ((line = sr.readLine()) != null) {
                if (line.length() > 0) {
                    i = 0;
                    while (i < len) {
                        line = StringUtil.changeString((String)line, (String)SPECIAL_SRC[i], (String)SPECIAL_DEST[i]);
                        ++i;
                    }
                }
                scs.add(line);
            }
            sr.close();
            if (scs.size() <= 0) {
                this.script.set((Object)new String[0]);
            } else {
                len = scs.size();
                String[] scriptList = new String[len];
                i = 0;
                while (i < len) {
                    scriptList[i] = (String)scs.get(i);
                    ++i;
                }
                this.script.set((Object)scriptList);
            }
        }
    }

    public synchronized void clear() {
        this.script.set(null);
        this.lists.clear();
    }

    public synchronized String get(int line) {
        if (line <= 0 || line > ((String[])this.script.get()).length) {
            return null;
        }
        return ((String[])this.script.get())[line - 1];
    }

    public synchronized SrcScriptList getLineBySrcScriptList(int line) {
        int len = this.lists.size();
        int i = 0;
        while (i < len) {
            SrcScriptList o = (SrcScriptList)this.lists.get(i);
            if (line >= o.getStart() && line <= o.getEnd()) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public synchronized void setSrcScriptList(SrcScriptList srcScriptList) throws Exception {
        if (srcScriptList == null || srcScriptList.getName() == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.lists.add((Object)srcScriptList);
    }

    public SrcScriptList getSrcScriptList(int no) {
        if (no < 0 || no >= this.lists.size()) {
            return null;
        }
        return (SrcScriptList)this.lists.get(no);
    }

    public synchronized int getSrcScriptListSize() {
        return this.lists.size();
    }

    public synchronized int lines() {
        return ((String[])this.script.get()).length;
    }

    public synchronized String toString() {
        if (this.script.get() != null) {
            String[] scriptList = (String[])this.script.get();
            StringBuilder buf = new StringBuilder();
            int len = scriptList.length;
            int i = 0;
            while (i < len) {
                buf.append(i).append(":").append(scriptList[i]);
                ++i;
            }
            return buf.toString();
        }
        return "";
    }

    public static final int getScriptList(String script) throws Exception {
        if (script == null || script.length() <= 0) {
            return 0;
        }
        int ret = 0;
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new StringReader(script));
            while ((s = br.readLine()) != null) {
                ++ret;
            }
            br.close();
            br = null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }
}

