/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.cache.CoreApiManager;
import org.maachang.comet.httpd.engine.script.cache.LibApiManager;
import org.maachang.comet.httpd.engine.script.cache.ModelApiManager;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.manager.GlobalManager;
import org.maachang.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheScriptManager {
    private CoreApiManager coreApiManager = new CoreApiManager();
    private ModelApiManager modelApiManager = new ModelApiManager();
    private LibApiManager libApiManager = new LibApiManager();
    private static CacheScriptManager thisObject = null;

    public static final void init() throws Exception {
        thisObject = new CacheScriptManager();
        GlobalManager.getInstance().put("SCRIPT_CACHE_MANAGER", (Object)thisObject);
    }

    public static final CacheScriptManager getInstance() {
        return thisObject;
    }

    private CacheScriptManager() throws Exception {
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        this.coreApiManager = null;
        this.modelApiManager = null;
        this.libApiManager = null;
    }

    public void reload() throws Exception {
        this.modelApiManager.reload();
        this.libApiManager.reload();
    }

    public void reload(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            this.reload();
        } else if ("model".equals(name = name.toLowerCase())) {
            this.modelApiManager.reload();
        } else if ("lib".equals(name)) {
            this.libApiManager.reload();
        } else {
            this.reload();
        }
    }

    public Bindings getBindings() throws Exception {
        this.modelApiManager.useScript();
        this.libApiManager.useScript();
        return ExternalBindings.getInstance();
    }

    public void script() throws Exception {
        this.modelApiManager.useScript();
        this.libApiManager.useScript();
    }

    public void exitScript() {
        ApiManager.removeLocal();
    }

    public SrcScript getSrcScript(String path) {
        if (path == null || (path = path.trim()).length() <= 0) {
            return null;
        }
        if (this.coreApiManager.isCache(path)) {
            return this.coreApiManager.getSrcScript(path);
        }
        if (this.modelApiManager.isCache(path)) {
            this.modelApiManager.setReloadFlag(true);
            return this.modelApiManager.getSrcScript();
        }
        if (this.libApiManager.isCache(path)) {
            this.libApiManager.setReloadFlag(true);
            return this.libApiManager.getSrcScript();
        }
        return null;
    }

    public boolean isCache(String path) {
        if (path == null || (path = path.trim()).length() <= 0) {
            return false;
        }
        if (this.coreApiManager.isCache(path)) {
            return true;
        }
        if (this.modelApiManager.isCache(path)) {
            return true;
        }
        return this.libApiManager.isCache(path);
    }

    public String getDirectory(String path) {
        if (path == null || (path = path.trim()).length() <= 0) {
            return "";
        }
        if (this.coreApiManager.isCache(path)) {
            return "";
        }
        if (this.modelApiManager.isCache(path)) {
            return this.modelApiManager.getDirectory();
        }
        if (this.libApiManager.isCache(path)) {
            return this.libApiManager.getDirectory();
        }
        return "";
    }

    public String[] getNames(Bindings bindings) {
        ObjectArray lst = new ObjectArray();
        this.pushMapKeys(lst, bindings);
        int len = lst.size();
        if (len > 0) {
            lst.sort();
            String[] ret = new String[len];
            System.arraycopy(lst.getObjects(), 0, ret, 0, len);
            lst.clear();
            return ret;
        }
        return null;
    }

    private void pushMapKeys(ObjectArray lst, Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (key == null || key.length() <= 0) continue;
                lst.add((Object)key);
            }
        }
    }
}

