/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

class LibApiManager {
    private static final Log LOG = LogFactory.getLog(LibApiManager.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[lib_api]";
    private static final String READ_DIR = LibApiManager.baseDir();
    private static final long CHECK_TIME = 30000L;
    private final AtomicLONG beforeTime = new AtomicLONG(-1L);
    private final AtomicOBJECT<String> libCode = new AtomicOBJECT();
    private final AtomicOBJECT<SrcScript> srcScript = new AtomicOBJECT();
    private final AtomicINT packageId = new AtomicINT(-1);
    private final AtomicBOOL reloadFlag = new AtomicBOOL(false);

    public LibApiManager() throws Exception {
        try {
            this.loadScript();
        }
        catch (Exception e) {
            LOG.error((Object)"## [libApi] loadScriptError", (Throwable)e);
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    private static final String baseDir() {
        try {
            return String.valueOf(FileUtil.getFullPath((String)"lib/")) + FileUtil.FILE_SPACE;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void clear() {
        this.reloadFlag.set(false);
        this.beforeTime.set(-1L);
        this.libCode.set(null);
        this.srcScript.set(null);
        this.packageId.set(-1);
    }

    public void reload() throws Exception {
        this.loadScript();
    }

    public void useScript() throws Exception {
        int pid;
        boolean reloadCheck = false;
        if (this.reloadFlag.get()) {
            this.reloadFlag.set(false);
            reloadCheck = true;
            String cd = (String)this.libCode.get();
            if (cd == null || !cd.equals(this.createLibMonitor())) {
                this.loadScript();
                return;
            }
        }
        if ((pid = this.packageId.get()) != -1 && pid != JsDef.getDefaultPackageId()) {
            this.loadScript();
            return;
        }
        if (this.beforeTime.get() + 30000L <= System.currentTimeMillis()) {
            String cd = (String)this.libCode.get();
            if (!(reloadCheck || cd != null && cd.equals(this.createLibMonitor()))) {
                this.loadScript();
            } else {
                this.beforeTime.set(System.currentTimeMillis());
            }
        }
    }

    public SrcScript getSrcScript() {
        return (SrcScript)this.srcScript.get();
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    public void setReloadFlag(boolean reloadFlag) {
        this.reloadFlag.set(reloadFlag);
    }

    public String getDirectory() {
        return "lib/";
    }

    private void loadScript() throws Exception {
        int cnt = 0;
        String beforeManagerCode = (String)this.libCode.get();
        int beforePackageId = this.packageId.get();
        long beforeBeforeTime = this.beforeTime.get();
        try {
            try {
                String[] libs = ScriptDef.getUseScript(READ_DIR);
                int startPos = 0;
                if (libs != null && libs.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    int[] outLine = new int[1];
                    this.libCode.set((Object)ScriptDef.getScriptManagerCode(libs, READ_DIR));
                    this.packageId.set(JsDef.pushDefaultPackage(outLine, buf));
                    this.beforeTime.set(System.currentTimeMillis());
                    startPos = outLine[0];
                    outLine = null;
                    int len = libs.length;
                    if (this.srcScript.get() == null) {
                        this.srcScript.set((Object)new SrcScript());
                    } else {
                        ((SrcScript)this.srcScript.get()).clear();
                    }
                    int i = 0;
                    while (i < len) {
                        String s = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + libs[i]), (String)"UTF8");
                        if (s != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">read[lib] - " + libs[i]));
                            }
                            if (cnt != 0) {
                                buf.append("\n");
                                ++startPos;
                            }
                            buf.append("/** libName << ").append(libs[i]).append(" >> **/\n");
                            int targetSize = SrcScript.getScriptList(s);
                            SrcScriptList srcLst = new SrcScriptList(libs[i], ++startPos, targetSize);
                            ((SrcScript)this.srcScript.get()).setSrcScriptList(srcLst);
                            buf.append(s);
                            startPos += targetSize;
                            ++cnt;
                        }
                        ++i;
                    }
                    String script = buf.toString();
                    buf = null;
                    ((SrcScript)this.srcScript.get()).create(script);
                    ExternalBindings bindings = ExternalBindings.getInstance();
                    bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                    ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
                    ApiManager.setScriptName((String)SCRIPT_NAME);
                    CompiledScript cs = ((Compilable)((Object)engine)).compile(script);
                    cs.eval((Bindings)bindings);
                    cs = null;
                    Map libManager = ApiManager.getLocal();
                    bindings.clear();
                    ApiManager.getInstance().setLibMap(libManager);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"** lib-cache\u3092\u8aad\u307f\u8fbc\u307f");
                    }
                }
                if (cnt <= 0) {
                    this.libCode.set(null);
                    this.packageId.set(-1);
                    ApiManager.getInstance().setLibMap(null);
                    this.beforeTime.set(System.currentTimeMillis());
                }
                this.reloadFlag.set(false);
            }
            catch (Exception e) {
                this.libCode.set((Object)beforeManagerCode);
                this.packageId.set(beforePackageId);
                this.beforeTime.set(beforeBeforeTime);
                throw e;
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }

    private String createLibMonitor() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"## read LibCode");
        }
        String[] libs = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(libs, READ_DIR);
    }
}

