/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.comet.httpd.engine.script.dao.DaoFactory;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

class ModelApiManager {
    private static final Log LOG = LogFactory.getLog(ModelApiManager.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[model_api]";
    protected static final String MODEL_NAME_FOODER = "Model";
    protected static final String MODEL_CUSTOM = "Custom";
    private static final String READ_DIR = ModelApiManager.baseDir();
    private static final long CHECK_TIME = 30000L;
    private final AtomicLONG beforeTime = new AtomicLONG(-1L);
    private final AtomicOBJECT<String> modelCode = new AtomicOBJECT();
    private final AtomicOBJECT<SrcScript> srcScript = new AtomicOBJECT();
    private final AtomicINT packageId = new AtomicINT(-1);
    private final AtomicBOOL reloadFlag = new AtomicBOOL(false);

    public ModelApiManager() throws Exception {
        try {
            if (GlobalManager.getValue((String)"DBMS_POOL") != null) {
                this.loadScript();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## [modelApi] loadScriptError", (Throwable)e);
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    private static final String baseDir() {
        try {
            return String.valueOf(FileUtil.getFullPath((String)"model/")) + FileUtil.FILE_SPACE;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void clear() {
        this.beforeTime.set(-1L);
        this.modelCode.set(null);
        this.srcScript.set(null);
        this.packageId.set(-1);
        this.reloadFlag.set(false);
    }

    public void reload() throws Exception {
        this.loadScript();
    }

    public void useScript() throws Exception {
        boolean reloadCheck = false;
        long time = System.currentTimeMillis();
        if (this.reloadFlag.get()) {
            reloadCheck = true;
            this.reloadFlag.set(false);
            String md = (String)this.modelCode.get();
            if (md == null || !md.equals(this.createModelMonitor())) {
                this.loadScript();
                return;
            }
        }
        if (GlobalManager.getValue((String)"DBMS_POOL") != null) {
            int pid = this.packageId.get();
            if (pid != -1 && pid != JsDef.getDefaultPackageId()) {
                this.loadScript();
                return;
            }
            if (this.beforeTime.get() + 30000L <= time) {
                String md = (String)this.modelCode.get();
                if (!(reloadCheck || md != null && md.equals(this.createModelMonitor()))) {
                    this.loadScript();
                } else {
                    this.beforeTime.set(System.currentTimeMillis());
                }
            }
        }
    }

    public SrcScript getSrcScript() {
        return (SrcScript)this.srcScript.get();
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    public void setReloadFlag(boolean reloadFlag) {
        this.reloadFlag.set(reloadFlag);
    }

    public String getDirectory() {
        return "model/";
    }

    private void loadScript() throws Exception {
        int cnt = 0;
        String beforeManagerCode = (String)this.modelCode.get();
        int beforePackageId = this.packageId.get();
        long beforeBeforeTime = this.beforeTime.get();
        try {
            try {
                DaoFactory daoFactory = this.getDaoFactory();
                if (daoFactory != null) {
                    daoFactory.clear();
                }
                String[] models = ScriptDef.getUseScript(READ_DIR);
                int startPos = 0;
                if (models != null && models.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    int[] outLine = new int[1];
                    this.modelCode.set((Object)ScriptDef.getScriptManagerCode(models, READ_DIR));
                    this.packageId.set(JsDef.pushDefaultPackage(outLine, buf));
                    this.beforeTime.set(System.currentTimeMillis());
                    startPos = outLine[0];
                    outLine = null;
                    int len = models.length;
                    if (this.srcScript.get() == null) {
                        this.srcScript.set((Object)new SrcScript());
                    } else {
                        ((SrcScript)this.srcScript.get()).clear();
                    }
                    buf.append("\nvar Models = {};\n");
                    startPos += 2;
                    int i = 0;
                    while (i < len) {
                        if (models[i].endsWith(".ms")) {
                            models[i] = models[i].substring(0, models[i].length() - ".ms".length());
                        }
                        if (!models[i].endsWith(MODEL_CUSTOM) && models[i].endsWith(MODEL_NAME_FOODER)) {
                            ++cnt;
                            String modelName = models[i].substring(0, models[i].length() - MODEL_NAME_FOODER.length());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">read[model] - " + modelName));
                            }
                            startPos = this.putModel(modelName, buf, (SrcScript)this.srcScript.get(), startPos);
                        }
                        ++i;
                    }
                    String script = buf.toString();
                    buf = null;
                    ((SrcScript)this.srcScript.get()).create(script);
                    ExternalBindings bindings = ExternalBindings.getInstance();
                    bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                    ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
                    ApiManager.setScriptName((String)SCRIPT_NAME);
                    CompiledScript cs = ((Compilable)((Object)engine)).compile(script);
                    cs.eval((Bindings)bindings);
                    cs = null;
                    Map modelManager = ApiManager.getLocal();
                    bindings.clear();
                    ApiManager.getInstance().setModelMap(modelManager);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"** model-cache\u3092\u8aad\u307f\u8fbc\u307f");
                    }
                }
                if (cnt <= 0) {
                    this.modelCode.set(null);
                    this.packageId.set(-1);
                    ApiManager.getInstance().setModelMap(null);
                    this.beforeTime.set(System.currentTimeMillis());
                }
                this.reloadFlag.set(false);
            }
            catch (Exception e) {
                this.modelCode.set((Object)beforeManagerCode);
                this.packageId.set(beforePackageId);
                this.beforeTime.set(beforeBeforeTime);
                throw e;
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }

    private String createModelMonitor() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"## read ModelCode");
        }
        String[] models = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(models, READ_DIR);
    }

    private int putModel(String model, StringBuilder buf, SrcScript srcScript, int startPos) throws Exception {
        buf.append("\n\n");
        buf.append("/** modelName << ").append(model).append(MODEL_NAME_FOODER).append(".ms").append(" >> **/\n");
        buf.append("var ").append(model).append(" = baseModel(\"").append(model).append("\");\n");
        buf.append("Models[\"").append(model).append("\"] = ").append(model).append(";\n");
        startPos += 5;
        String modelScript = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + model + MODEL_NAME_FOODER + ".ms"), (String)"UTF8");
        if (modelScript != null && (modelScript = modelScript.trim()).length() > 0) {
            int targetSize = SrcScript.getScriptList(modelScript);
            SrcScriptList srcLst = new SrcScriptList(model, startPos, targetSize);
            ((SrcScript)this.srcScript.get()).setSrcScriptList(srcLst);
            buf.append(modelScript).append("\n");
            startPos += targetSize + 1;
        }
        modelScript = null;
        String customName = model + MODEL_CUSTOM + ".ms";
        String custom = String.valueOf(READ_DIR) + "/" + customName;
        if (FileUtil.isFileExists((String)custom) && (modelScript = FileUtil.getFileByString((String)custom, (String)"UTF8")) != null && (modelScript = modelScript.trim()).length() > 0) {
            buf.append("/** modelName(Custom) << ").append(customName).append(" >> **/\n");
            int targetSize = SrcScript.getScriptList(modelScript);
            SrcScriptList srcLst = new SrcScriptList(customName, ++startPos, targetSize);
            ((SrcScript)this.srcScript.get()).setSrcScriptList(srcLst);
            buf.append(modelScript).append("\n");
            startPos += targetSize + 1;
        }
        return startPos;
    }

    private DaoFactory getDaoFactory() {
        return (DaoFactory)GlobalManager.getInstance().get("DAO_FACTORY");
    }
}

