/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cron;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.cron.CronBean;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class CronConfig {
    private static final Log LOG = LogFactory.getLog(CronConfig.class);
    private static final String READ_FILE = "conf/cron.conf";
    private static final long CHECK_TIMING = 15000L;
    private static final String CHARSET = "UTF8";
    private static final int CRON_LINE = 6;
    private Config iniParams = null;
    private String fileName = null;
    private long lastUpdate = -1L;
    private long lastCheckTime = -1L;
    private ArrayList<CronBean> manager = null;

    public synchronized void open() throws Exception {
        this.open(READ_FILE);
    }

    public synchronized void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.updateToReload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public synchronized void close() {
        this.manager = null;
        this.iniParams = null;
        this.fileName = null;
        this.lastUpdate = -1L;
        this.lastCheckTime = -1L;
    }

    public synchronized String toString() {
        if (this.iniParams != null) {
            return this.iniParams.toString();
        }
        return "null";
    }

    public synchronized int size(boolean[] out) {
        if (this.manager != null) {
            boolean res = this.updateToReload();
            if (out != null && out.length > 0) {
                out[0] = res;
            }
            return this.manager.size();
        }
        return 0;
    }

    public synchronized CronBean get(boolean[] out, int no) {
        if (this.manager != null) {
            boolean res = this.updateToReload();
            if (out != null && out.length > 0) {
                out[0] = res;
            }
            if (no <= -1 || no >= this.manager.size()) {
                return null;
            }
            return this.manager.get(no);
        }
        return null;
    }

    private boolean updateToReload() {
        boolean ret = false;
        if (this.lastCheckTime + 15000L <= System.currentTimeMillis()) {
            try {
                long tm = FileUtil.getLastTime((String)this.fileName);
                if (this.lastUpdate == -1L || this.lastUpdate != tm) {
                    this.reload();
                    this.createConfigByCronBeans();
                    ret = true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"* * * Cron\u30b3\u30f3\u30d5\u30a3\u30b0\u8aad\u307f\u8fbc\u307f\u5931\u6557", (Throwable)e);
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return ret;
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                this.iniParams = iniParams;
                this.lastUpdate = last;
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private final void createConfigByCronBeans() throws Exception {
        this.manager = new ArrayList();
        if (this.iniParams == null || !this.iniParams.isSection("cron-tab")) {
            return;
        }
        int len = this.iniParams.size("cron-tab", "cron");
        int i = 0;
        while (i < len) {
            String s = this.iniParams.get("cron-tab", "cron", i);
            ArrayList one = StringUtil.getCsv((boolean)false, (String)s, (String)",");
            if (one == null) {
                LOG.warn((Object)("Cron\u5185\u5bb9[no" + (i + 1) + "]\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f"));
            } else {
                int lenJ = one.size();
                if (lenJ != 6) {
                    LOG.warn((Object)("Cron\u5185\u5bb9[no" + (i + 1) + " data:" + s + "]\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059(" + lenJ + "/" + 6 + ")"));
                } else {
                    CronBean bean = new CronBean();
                    try {
                        int j = 0;
                        while (j < lenJ) {
                            String ss = (String)one.get(j);
                            if (ss != null && (ss = ss.trim()).length() > 0 && !"*".equals(ss)) {
                                if (ss.startsWith("(") && ss.endsWith(")")) {
                                    String tm = ss.substring(1, ss.length() - 1);
                                    int cd = Integer.parseInt(tm = tm.trim());
                                    if (cd <= 0) {
                                        cd = -1;
                                    }
                                    switch (j) {
                                        case 0: {
                                            bean.setMinuteTm(cd);
                                            break;
                                        }
                                        case 1: {
                                            bean.setHourTm(cd);
                                            break;
                                        }
                                        case 2: {
                                            bean.setDateTm(cd);
                                            break;
                                        }
                                        case 3: 
                                        case 4: 
                                        case 5: {
                                            bean = null;
                                            LOG.warn((Object)("Cron\u5185\u5bb9[no" + (i + 1) + " data:" + s + "]\u306e\u6708,\u66dc\u65e5,\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u5bb9\u306f\u6761\u4ef6\u6307\u5b9a\u304c\u3067\u304d\u307e\u305b\u3093"));
                                        }
                                    }
                                } else {
                                    switch (j) {
                                        case 0: {
                                            bean.setMinute(Integer.parseInt(ss));
                                            break;
                                        }
                                        case 1: {
                                            bean.setHour(Integer.parseInt(ss));
                                            break;
                                        }
                                        case 2: {
                                            bean.setDate(Integer.parseInt(ss));
                                            break;
                                        }
                                        case 3: {
                                            bean.setMonth(Integer.parseInt(ss));
                                            break;
                                        }
                                        case 4: {
                                            bean.setWeek(Integer.parseInt(ss));
                                            break;
                                        }
                                        case 5: {
                                            bean.setScript(ss);
                                        }
                                    }
                                }
                                if (bean == null) break;
                            }
                            ++j;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Cron\u5185\u5bb9[no" + (i + 1) + " data:" + s + "]\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f"), (Throwable)e);
                        bean = null;
                    }
                    if (bean != null) {
                        if (bean.getScript() == null) {
                            LOG.warn((Object)("Cron\u5185\u5bb9[no" + (i + 1) + " data:" + s + "]\u306b\u5bfe\u3057\u3066\u3001\u5b9f\u884c\u30b9\u30af\u30ea\u30d7\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
                            bean = null;
                        } else if (bean.getMinute() <= -1 && bean.getMinuteTm() <= -1 && bean.getHour() <= -1 && bean.getHourTm() <= -1 && bean.getDate() <= -1 && bean.getDateTm() <= -1 && bean.getMonth() <= -1 && bean.getWeek() <= -1) {
                            LOG.warn((Object)("Cron\u5185\u5bb9[no" + (i + 1) + " data:" + s + "]\u306b\u5bfe\u3057\u3066\u3001\u5b9f\u884c\u53ef\u80fd\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
                            bean = null;
                        } else {
                            this.manager.add(bean);
                        }
                    }
                }
            }
            ++i;
        }
    }
}

