/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.dao;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.comet.httpd.engine.script.dao.MasterCacheChild;
import org.maachang.comet.httpd.engine.script.dao.MasterCacheMonitor;

public class MasterCache {
    private static final long DEF_DESTROY_TIME = 300000L;
    private static final long MIN_DESTROY_TIME = 30000L;
    private static final long MAX_DESTROY_TIME = 2678400000L;
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private MasterCacheMonitor mon = null;

    public MasterCache() throws Exception {
        this(300000L);
    }

    public MasterCache(long time) throws Exception {
        if (time <= -1L) {
            time = 2678400000L;
        } else if (time <= 30000L) {
            time = 30000L;
        } else if (time >= 2678400000L) {
            time = 2678400000L;
        }
        this.mon = new MasterCacheMonitor(this.cache, time);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.mon != null) {
            this.mon.destroy();
        }
        if (this.cache != null) {
            this.cache.clear();
        }
        this.mon = null;
    }

    public void clear() {
        this.cache.clear();
    }

    public void put(String key, Object value) {
        if (key == null || (key = key.trim()).length() <= 0 || value == null) {
            return;
        }
        this.cache.put(key, value);
    }

    public void putByCache(String key, Object value) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        this.cache.put(key, new MasterCacheChild(value));
    }

    public void clearCache(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        Object o = this.cache.get(key);
        if (o instanceof MasterCacheChild) {
            ((MasterCacheChild)o).clearValue();
        }
    }

    public void remove(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        this.cache.remove(key);
    }

    public Object get(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return null;
        }
        return this.cache.get(key);
    }

    public boolean containsKey(String key) {
        return this.cache.containsKey(key);
    }

    public int size() {
        return this.cache.size();
    }

    public Object[] getKeys() {
        return this.cache.keySet().toArray();
    }
}

