/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.mdbm;

import java.net.InetAddress;
import org.maachang.comet.conf.IniFile;
import org.maachang.conf.ConvIniParam;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmIO;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.client.MDbmDriverManager;
import org.maachang.manager.GlobalManager;
import org.maachang.util.atomic.AtomicOBJECT;

public class SingleMDbm {
    private static final SingleMDbm SNGL = new SingleMDbm();
    private final AtomicOBJECT<MDbm> mdbm = new AtomicOBJECT();

    private SingleMDbm() {
    }

    public static final SingleMDbm getInstance() {
        return SNGL;
    }

    public boolean createMDbm(boolean console) throws Exception {
        return this.privateCreateMDbm(console);
    }

    public MDbm getMDbm() throws Exception {
        return this.privateGetMDbm();
    }

    public MDbm getMDbm(boolean mode) throws Exception {
        MDbm ret = this.privateGetMDbm();
        if (ret instanceof MDbmIO) {
            ret = MDbmManager.getInstance().getTransaction(ret);
        }
        return ret;
    }

    public boolean isCreate() {
        return this.privateGetMDbm() != null;
    }

    private boolean privateCreateMDbm(boolean console) throws Exception {
        if (this.mdbm.get() == null) {
            if (!console) {
                this.mdbm.set((Object)MDbmManager.getInstance().getMDbm());
            } else {
                IniFile config = (IniFile)GlobalManager.getInstance().get("CONFIG_MANAGER");
                if (ConvIniParam.getBoolean((String)config.get("mdbm", "flag", 0))) {
                    InetAddress addr = ConvIniParam.getInetAddress((String)config.get("mdbm", "bind-addr", 0));
                    int port = ConvIniParam.getInt((String)config.get("mdbm", "bind-port", 0));
                    if (addr == null) {
                        addr = InetAddress.getByName("127.0.0.1");
                    }
                    if (port <= -1) {
                        port = -1;
                    }
                    this.mdbm.set((Object)MDbmDriverManager.getConnection((InetAddress)addr, (int)port));
                }
            }
            return true;
        }
        return false;
    }

    private MDbm privateGetMDbm() {
        return (MDbm)this.mdbm.get();
    }
}

