/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.comet.net.nio.KeepAliveBean;
import org.maachang.comet.net.nio.KeepAliveFactory;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioInputStream;
import org.maachang.comet.net.nio.NioOutputStream;

class ConnectionInfoImpl
implements ConnectionInfo {
    private KeepAliveBean keepAlive = null;
    private NioElement element = null;
    private InetAddress address = null;
    private int port = -1;
    private boolean cloesFlag = false;
    private boolean cometFlag = false;
    private final NioInputStream inputStream = new NioInputStream();
    private final NioOutputStream outputStream = new NioOutputStream();

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.element != null) {
            this.element.destroy();
        }
        this.inputStream.close();
        this.outputStream.clear();
        this.keepAlive = null;
        this.element = null;
        this.address = null;
        this.port = -1;
        this.cloesFlag = false;
        this.cometFlag = false;
    }

    public ConnectionInfo create(NioElement element) throws Exception {
        this.clear();
        if (element == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!element.isUse()) {
            return null;
        }
        KeepAliveBean keepAlive = (KeepAliveBean)element.getObject();
        if (keepAlive == null) {
            keepAlive = KeepAliveFactory.getInstance().getBean();
            element.setObject(keepAlive);
        }
        this.element = element;
        this.keepAlive = keepAlive;
        this.address = element.getChannel().socket().getInetAddress();
        this.port = element.getChannel().socket().getPort();
        return this;
    }

    public void clear() {
        this.inputStream.close();
        this.outputStream.clear();
        this.keepAlive = null;
        this.element = null;
        this.address = null;
        this.port = -1;
        this.cloesFlag = false;
    }

    public ConnectionInfo copy() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        ConnectionInfoImpl ret = new ConnectionInfoImpl();
        this.inputStream.close();
        ret.keepAlive = this.keepAlive;
        ret.element = this.element;
        ret.address = this.address;
        ret.port = this.port;
        ret.cloesFlag = this.cloesFlag;
        return ret;
    }

    public NioElement getElement() {
        if (!this.isUse()) {
            return null;
        }
        return this.element;
    }

    public void setTimeout(int time) {
        this.keepAlive.setTime(time);
    }

    public long getTimeout() {
        return this.keepAlive.getTime();
    }

    public int getCount() {
        return this.keepAlive.getCount();
    }

    public OutputStream getOutputStream() throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return this.outputStream.create(this.element);
    }

    public InputStream getInputStream() throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return this.inputStream.create(this.element);
    }

    public InputStream getInputStream(long timeout) throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return this.inputStream.create(this.element, timeout);
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void setCloseFlag(boolean mode) {
        this.cloesFlag = mode;
    }

    public boolean recyclingConnection() {
        if (!this.isUse()) {
            return false;
        }
        int cnt = this.keepAlive.getCount() - 1;
        this.keepAlive.setCount(cnt);
        if (cnt <= 0) {
            return false;
        }
        this.element.setExecutionFlag(false);
        return true;
    }

    public boolean isCloseFlag() {
        return this.cloesFlag;
    }

    public boolean isUse() {
        boolean ret;
        boolean bl = ret = this.element != null && this.element.getChannel() != null;
        if (!ret && this.element != null) {
            this.element.destroy();
        }
        return ret;
    }

    public void cometOn() {
        this.cometFlag = true;
    }

    public boolean isComet() {
        boolean ret = this.cometFlag;
        this.cometFlag = false;
        return ret;
    }
}

