/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.ReceiveBuffer;
import org.maachang.comet.net.nio.SendBuffer;
import org.maachang.comet.net.ssl.SslElement;
import org.maachang.comet.net.ssl.SslOption;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public class NioElement {
    private final AtomicOBJECT<SelectionKey> key = new AtomicOBJECT();
    private final AtomicOBJECT<SocketChannel> channel = new AtomicOBJECT();
    private final AtomicOBJECT<IsWriteQueue> isWriteQueue = new AtomicOBJECT();
    private final AtomicLONG time = new AtomicLONG(-1L);
    private final AtomicBOOL executionFlag = new AtomicBOOL(false);
    private final AtomicBOOL closeFlag = new AtomicBOOL(false);
    private final AtomicOBJECT<Object> object = new AtomicOBJECT();
    private final AtomicOBJECT<SslElement> sslElement = new AtomicOBJECT();
    private final AtomicOBJECT<SslOption> sslOption = new AtomicOBJECT();
    private final ReceiveBuffer recvBuffer = new ReceiveBuffer();
    private final SendBuffer sendBuffer = new SendBuffer();

    private NioElement() {
    }

    public NioElement(SocketChannel channel) throws Exception {
        this(channel, null);
    }

    public NioElement(SocketChannel ch, IsWriteQueue queue) throws Exception {
        if (ch == null) {
            throw new IOException("\u30bd\u30b1\u30c3\u30c8\u30c1\u30e3\u30cd\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.channel.set((Object)ch);
        this.isWriteQueue.set((Object)queue);
        this.time.set(System.currentTimeMillis());
        this.executionFlag.set(false);
        this.closeFlag.set(false);
        this.object.set(null);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        if (this.sslElement.get() != null) {
            ((SslElement)this.sslElement.get()).destroy();
        }
        this.sslElement.set(null);
        if (this.key.get() != null) {
            ((SelectionKey)this.key.get()).attach(null);
            try {
                ((SelectionKey)this.key.get()).cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.key.set(null);
        if (this.channel.get() != null) {
            try {
                ((SocketChannel)this.channel.get()).socket().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((SocketChannel)this.channel.get()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel.set(null);
        this.isWriteQueue.set(null);
        this.object.set(null);
        this.executionFlag.set(false);
        this.closeFlag.set(false);
        this.sslOption.set(null);
        this.recvBuffer.destroy();
        this.sendBuffer.destroy();
    }

    protected void setIsWriteQueue(IsWriteQueue queue) {
        this.isWriteQueue.set((Object)queue);
    }

    protected void setSsl(SslOption op) {
        this.sslOption.set((Object)op);
        this.sslElement.set(null);
    }

    public SslElement getSslElement() {
        return (SslElement)this.sslElement.get();
    }

    public SslOption getSslOption() {
        return (SslOption)this.sslOption.get();
    }

    public void createSsl() throws Exception {
        if (this.sslOption.get() != null && this.sslElement.get() == null) {
            this.sslElement.set((Object)new SslElement(this, ((SslOption)this.sslOption.get()).getSSLEngine()));
        }
    }

    public void clearSsl() {
        this.sslElement.set(null);
    }

    public void setKey(SelectionKey k) {
        this.key.set((Object)k);
    }

    public SelectionKey getKey() {
        return (SelectionKey)this.key.get();
    }

    public SocketChannel getChannel() {
        return (SocketChannel)this.channel.get();
    }

    public ReceiveBuffer getReceiveBuffer() {
        return this.recvBuffer;
    }

    public boolean isReceiveBuffer() {
        return this.recvBuffer.isData();
    }

    public void restartWrite() {
        if (this.isWriteQueue.get() != null && this.key.get() != null && (((SelectionKey)this.key.get()).interestOps() & 4) == 0) {
            ((IsWriteQueue)this.isWriteQueue.get()).append(this);
            ((SelectionKey)this.key.get()).selector().wakeup();
        }
    }

    public SendBuffer getSendBuffer() {
        return this.sendBuffer;
    }

    public void setCloseFlag(boolean mode) {
        this.closeFlag.set(mode);
    }

    public boolean isCloseFlag() {
        return this.closeFlag.get();
    }

    public void update() {
        this.time.set(System.currentTimeMillis());
    }

    public long getTime() {
        return this.time.get();
    }

    protected void setExecutionFlag(boolean flg) {
        this.executionFlag.set(flg);
        if (!flg) {
            this.update();
        }
    }

    protected boolean isExecutionFlag() {
        return this.executionFlag.get();
    }

    public void setObject(Object o) {
        this.object.set(o);
    }

    public Object getObject() {
        return this.object.get();
    }

    public boolean isUse() {
        boolean ret;
        boolean bl = ret = this.channel.get() != null && ((SocketChannel)this.channel.get()).socket() != null;
        if (!ret) {
            if (this.sslElement.get() != null) {
                ((SslElement)this.sslElement.get()).destroy();
            }
            this.sslElement.set(null);
            this.recvBuffer.destroy();
            this.sendBuffer.destroy();
        }
        return ret;
    }
}

