/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.SendBuffer;

class NioOutputStream
extends OutputStream {
    protected static final int BUFFER_LENGTH = 1024;
    private NioElement element = null;
    private SendBuffer sendBuffer = null;
    private final byte[] temp = new byte[1024];
    private int count = 0;

    public NioOutputStream create(NioElement element) throws Exception {
        if (element == null || !element.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.close();
        this.element = element;
        this.sendBuffer = element.getSendBuffer();
        this.element.update();
        return this;
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    protected void clear() {
        if (this.sendBuffer != null && this.sendBuffer.isUse() && !this.sendBuffer.isLast()) {
            this.sendBuffer.last();
            try {
                this.flushTo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.element = null;
        this.sendBuffer = null;
        this.count = 0;
    }

    public void close() throws IOException {
        this.clear();
    }

    public void flush() throws IOException {
        if (this.sendBuffer == null || !this.sendBuffer.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.flushTo();
    }

    private void flushTo() throws IOException {
        if (this.count > 0) {
            this.sendBuffer.write(this.temp, this.count);
            this.count = 0;
            this.element.restartWrite();
        }
        this.element.update();
    }

    public void write(int b) throws IOException {
        if (this.sendBuffer == null || !this.sendBuffer.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.count >= 1024) {
            this.flush();
        }
        this.temp[this.count] = (byte)b;
        ++this.count;
    }
}

