/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.HttpReceiveCallback;
import org.maachang.comet.net.HttpdRequestImpl;
import org.maachang.comet.net.HttpdResponseImpl;
import org.maachang.comet.net.ReadHttpdRequest;
import org.maachang.comet.net.RequestBuffer;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.comet.net.nio.ConnectionInfoImpl;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.SequenceSync;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.thread.LoopThread;

class NioPoolThread
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(NioPoolThread.class);
    private static final long TIMEOUT = 15000L;
    private HttpReceiveCallback call = null;
    private ReceiveLinkQueue queue = null;
    private SequenceSync sequence = null;
    private AtomicINT actionLength = null;
    private final RequestBuffer requestBuffer = new RequestBuffer();
    private final ConnectionInfoImpl connectionInfo = new ConnectionInfoImpl();
    private final HttpdRequestImpl request = new HttpdRequestImpl();
    private final HttpdResponseImpl response = new HttpdResponseImpl();

    private NioPoolThread() {
    }

    public NioPoolThread(HttpReceiveCallback call, ReceiveLinkQueue queue, AtomicINT actionLength, SequenceSync sequence, int threadId) throws Exception {
        if (call == null || queue == null || actionLength == null || sequence == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.call = call;
        this.queue = queue;
        this.actionLength = actionLength;
        this.sequence = sequence;
        this.threadId.set(threadId);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        this.queue = null;
        this.call = null;
    }

    protected boolean execution() throws Exception {
        NioElement element = null;
        while (true) {
            if ((element = this.queue.getQueue()) != null) {
                this.actionLength.inc();
                try {
                    try {
                        this.executionServer(element);
                    }
                    catch (Exception e) {
                        if (element != null) {
                            element.destroy();
                        }
                        element = null;
                        throw e;
                    }
                    catch (Error err) {
                        if (element != null) {
                            element.destroy();
                        }
                        element = null;
                        throw err;
                    }
                }
                finally {
                    this.actionLength.dec();
                }
                continue;
            }
            Thread.sleep(1L);
        }
    }

    protected void toException(Throwable e) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executionServer(NioElement element) throws Exception {
        String url = null;
        long time = -1L;
        int id = -1;
        while (true) {
            boolean pipeline;
            block21: {
                block22: {
                    try {
                        if (LOG.isDebugEnabled()) {
                            time = System.currentTimeMillis();
                        }
                        url = null;
                        id = this.sequence.getId();
                        if (this.connectionInfo.create(element) == null) {
                            if (element == null) return;
                            element.destroy();
                            return;
                        }
                        this.request.clear();
                    }
                    catch (Exception e) {
                        if (element != null) {
                            element.destroy();
                        }
                        if (!LOG.isDebugEnabled()) throw e;
                        StringBuilder buf = new StringBuilder();
                        buf.append(" ## $$$$$ error ").append("## id[").append(id).append("]-threadId:(").append(this.threadId);
                        if (url != null) {
                            buf.append(") url:").append(url).append(" ");
                        } else {
                            buf.append(") ");
                        }
                        buf.append(System.currentTimeMillis() - time).append("msec - message:").append(e.getMessage());
                        LOG.debug((Object)buf.toString(), (Throwable)e);
                        throw e;
                    }
                    NioPoolThread.readHttpdRequest(this.request, this.connectionInfo, this.requestBuffer, id);
                    pipeline = element.isReceiveBuffer();
                    if (LOG.isDebugEnabled()) {
                        url = this.request.getUrlPath();
                        LOG.debug((Object)(" ## ***** start " + "receive(" + id + ") - [" + this.connectionInfo.getInetAddress().getHostAddress() + ":" + this.connectionInfo.getPort() + "] - threadId:(" + this.threadId + (") url:" + url)));
                    }
                    this.call.execution(this.connectionInfo, id, this.request, this.response);
                    this.request.clear();
                    this.response.clear();
                    if (this.connectionInfo.isComet()) break block21;
                    if (!this.connectionInfo.isUse()) break block22;
                    if (this.connectionInfo.isCloseFlag()) {
                        element.setCloseFlag(true);
                        break block21;
                    } else if (!this.connectionInfo.recyclingConnection()) {
                        element.setCloseFlag(true);
                        break block21;
                    } else {
                        element.setCloseFlag(false);
                    }
                    break block21;
                }
                element.destroy();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" ## @@@@@ end " + "## id[" + id + "]-threadId:(" + this.threadId + ") url:" + url + " " + (System.currentTimeMillis() - time) + "msec"));
            }
            if (!pipeline) {
                return;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)"#### pipline - next");
        }
        finally {
            this.connectionInfo.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean readHttpdRequest(HttpdRequestImpl request, ConnectionInfo info, RequestBuffer buf, int seqId) throws Exception {
        if (info == null) throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        if (!info.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        InputStream in = null;
        try {
            in = info.getInputStream(15000L);
            ReadHttpdRequest.receiveHttpRequest(request, info, in, buf, seqId);
            in.close();
            in = null;
            return true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

