/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioTcpUtil;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.thread.LoopThread;

class NioSingleTcpServer
extends LoopThread {
    private static final int BUFFER_LENGTH = 512;
    private ServerSocket serverSocket = null;
    private ServerSocketChannel server = null;
    private Selector selector = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;
    private final ByteBuffer sendBuffer = ByteBuffer.allocateDirect(1024);
    private final ByteBuffer recvBuffer = ByteBuffer.allocateDirect(512);

    private NioSingleTcpServer() {
    }

    public NioSingleTcpServer(ServerSocketChannel channel, ReceiveLinkQueue executionQueue) throws Exception {
        if (channel == null || executionQueue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.serverSocket = channel.socket();
        this.serverSocket.setReuseAddress(true);
        this.server = channel;
        this.selector = Selector.open();
        this.server.register(this.selector, 16);
        this.executionQueue = executionQueue;
        this.isWriteQueue = new IsWriteQueue();
        super.setPriority(6);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        NioTcpUtil.destroyKey(itr.next());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
        this.server = null;
        this.isWriteQueue = null;
        this.executionQueue = null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean execution() throws Exception {
        wakeupFlag = false;
        counter = 0;
        block0: while (true) {
            if (NioTcpUtil.isWrite(this.isWriteQueue)) {
                wakeupFlag = true;
            }
            if (wakeupFlag) {
                wakeupFlag = false;
                counter = this.selector.selectNow();
            } else {
                wakeupFlag = false;
                counter = this.selector.select();
            }
            if (counter <= 0) continue;
            itr = this.selector.selectedKeys().iterator();
            while (true) {
                if (itr.hasNext()) ** break;
                continue block0;
                if (NioTcpUtil.isWrite(this.isWriteQueue)) {
                    wakeupFlag = true;
                }
                key = itr.next();
                itr.remove();
                if (key == null) continue;
                if (!key.isValid()) {
                    NioTcpUtil.destroyKey(key);
                    continue;
                }
                if (NioTcpUtil.toAcceptBySingle(this.selector, key, this.isWriteQueue)) continue;
                NioTcpUtil.isRead(this.selector, key, this.executionQueue, this.recvBuffer);
                NioTcpUtil.isWrite(this.selector, key, this.sendBuffer);
            }
            break;
        }
    }

    protected void toException(Throwable e) {
    }
}

