/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioSslReceiveServerArray;
import org.maachang.comet.net.nio.NioSslServer;
import org.maachang.comet.net.nio.NioTcpUtil;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.comet.net.nio.SendBuffer;
import org.maachang.comet.net.ssl.CloseSslException;
import org.maachang.comet.net.ssl.SslElement;
import org.maachang.comet.net.ssl.SslOption;

abstract class NioSslUtil {
    private static final Log LOG = LogFactory.getLog(NioSslServer.class);

    NioSslUtil() {
    }

    protected static final boolean toAcceptBySingle(Selector selector, SelectionKey key, IsWriteQueue queue, SslOption option) throws Exception {
        if ((key.readyOps() & 0x10) == 16) {
            block8: {
                SocketChannel sc = null;
                try {
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    sc = ssc.accept();
                    if (sc != null) {
                        NioTcpUtil.setOption(sc);
                        NioElement em = new NioElement(sc, queue);
                        em.setSsl(option);
                        em.createSsl();
                        SelectionKey regKey = sc.register(selector, 1, em);
                        if (regKey != null) {
                            em.setKey(regKey);
                        } else {
                            em.destroy();
                        }
                    }
                }
                catch (Exception e) {
                    if (sc == null) break block8;
                    try {
                        sc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean toAcceptByPlural(SelectionKey key, NioSslReceiveServerArray recvServer, SslOption option) throws Exception {
        if ((key.readyOps() & 0x10) == 16) {
            block6: {
                SocketChannel sc = null;
                try {
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    sc = ssc.accept();
                    if (sc != null) {
                        NioTcpUtil.setOption(sc);
                        NioElement em = new NioElement(sc);
                        em.setSsl(option);
                        em.createSsl();
                        recvServer.setElement(em);
                    }
                }
                catch (Exception e) {
                    if (sc == null) break block6;
                    try {
                        sc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean isRead(Selector selector, SelectionKey key, ReceiveLinkQueue queue) throws Exception {
        if ((key.readyOps() & 1) == 1) {
            block13: {
                NioElement em = NioTcpUtil.getNioElement(key);
                if (em == null) {
                    return true;
                }
                SslElement ssl = em.getSslElement();
                ByteBuffer buffer = null;
                try {
                    buffer = ssl.getRecvBuffer();
                    if (!ssl.isSendEndHandShake()) {
                        int len = em.getChannel().read(buffer);
                        if (len <= 0) {
                            if (len <= -1) {
                                em.destroy();
                                return true;
                            }
                        } else {
                            ssl.handShake(buffer);
                            while (ssl.isUseReadData(buffer)) {
                                ssl.handShake(buffer);
                            }
                            key.interestOps(key.interestOps() | 4);
                        }
                    } else {
                        if (!ssl.read(buffer)) {
                            em.destroy();
                            return true;
                        }
                        if (!em.isExecutionFlag()) {
                            em.setExecutionFlag(true);
                            queue.append(em);
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                }
                catch (Exception e) {
                    if (em != null) {
                        em.destroy();
                    }
                    if (buffer == null) break block13;
                    buffer.clear();
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean isWrite(Selector selector, SelectionKey key, ReceiveLinkQueue queue, ByteBuffer buf) throws Exception {
        if (key.isValid() && (key.readyOps() & 4) == 4) {
            block18: {
                NioElement em = NioTcpUtil.getNioElement(key);
                if (em == null) {
                    return true;
                }
                SslElement ssl = em.getSslElement();
                ByteBuffer buffer = null;
                try {
                    buffer = ssl.getRecvBuffer();
                    SendBuffer sendBuffer = em.getSendBuffer();
                    if (!ssl.isSendEndHandShake()) {
                        if (sendBuffer.read(buf)) {
                            em.getChannel().write(buf);
                        }
                        if (sendBuffer.length() <= 0 && ssl.isHandShake()) {
                            ssl.sendEndHandShake();
                            key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            if (ssl.readTo(buffer) && !em.isExecutionFlag()) {
                                em.setExecutionFlag(true);
                                queue.append(em);
                            }
                        }
                    } else if (sendBuffer.read(buf)) {
                        ssl.write(buf);
                    } else if (sendBuffer.isLast()) {
                        sendBuffer.reset();
                        if (em.isCloseFlag()) {
                            ssl.close();
                            em.destroy();
                            return true;
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    } else {
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                }
                catch (CloseSslException cs) {
                    if (em != null) {
                        em.destroy();
                    }
                    if (buffer != null) {
                        buffer.clear();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"ssl@writeError", (Throwable)e);
                    if (em != null) {
                        em.destroy();
                    }
                    if (buffer == null) break block18;
                    buffer.clear();
                }
            }
            return true;
        }
        return false;
    }
}

