/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicOBJECT;

public class ReceiveBuffer {
    private static final Log LOG = LogFactory.getLog(ReceiveBuffer.class);
    protected static final int MAX_LENGTH = 0x2000000;
    private static final int BUFFER = 8192;
    private final AtomicOBJECT<byte[]> binary = new AtomicOBJECT((Object)new byte[8192]);
    private final AtomicINT binaryLength = new AtomicINT(8192);
    private final AtomicINT length = new AtomicINT(0);
    private final AtomicINT position = new AtomicINT(0);
    private final AtomicBOOL useConnectFlag = new AtomicBOOL(true);

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        this.useConnectFlag.set(false);
        this.binary.set(null);
    }

    public void reset() {
        if (this.useConnectFlag.get() && !this.compact()) {
            if (this.binaryLength.get() != 8192) {
                this.binary.set((Object)new byte[8192]);
                this.binaryLength.set(8192);
            }
            this.length.set(0);
            this.position.set(0);
        }
    }

    public void put(ByteBuffer buf) throws Exception {
        if (buf.limit() < buf.position()) {
            buf.flip();
        }
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int len = buf.limit();
        int binLength = this.length.get();
        if (binLength + len >= 0x2000000) {
            this.reset();
            LOG.warn((Object)"## \u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u6700\u5927\u5024[33554432]\u3092\u8d8a\u3057\u305f\u5185\u5bb9\u3092\u78ba\u8a8d\u3057\u307e\u3057\u305f");
            throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u6700\u5927\u5024[33554432]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.addLimit(len);
        buf.get((byte[])this.binary.get(), binLength, len);
        this.length.add(len);
        buf.clear();
    }

    public byte get(long timeout) throws IOException {
        if (timeout <= -1L) {
            while (true) {
                int binPosition;
                if (!this.useConnectFlag.get()) {
                    throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
                }
                int binLength = this.length.get();
                if (binLength > (binPosition = this.position.get())) {
                    byte ret = ((byte[])this.binary.get())[binPosition];
                    this.position.inc();
                    return ret;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        long t = System.currentTimeMillis() + timeout;
        int c = 0;
        while (true) {
            int binPosition;
            if (!this.useConnectFlag.get()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            int binLength = this.length.get();
            if (binLength > (binPosition = this.position.get())) {
                byte ret = ((byte[])this.binary.get())[binPosition];
                this.position.inc();
                return ret;
            }
            if (c > 100) {
                if (System.currentTimeMillis() >= t) {
                    throw new SocketTimeoutException("\u53d7\u4fe1\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u691c\u77e5");
                }
                c = -1;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++c;
        }
    }

    public int get(long timeout, byte[] out, int off, int len) throws IOException {
        if (timeout <= -1L) {
            while (true) {
                int binPosition;
                if (!this.useConnectFlag.get()) {
                    throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
                }
                int binLength = this.length.get();
                if (binLength > (binPosition = this.position.get())) {
                    int readLen = binLength - binPosition;
                    readLen = readLen > len ? len : readLen;
                    System.arraycopy(this.binary.get(), binPosition, out, off, readLen);
                    this.position.add(readLen);
                    return readLen;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception readLen) {}
            }
        }
        long t = System.currentTimeMillis() + timeout;
        int c = 0;
        while (true) {
            int binPosition;
            if (!this.useConnectFlag.get()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            int binLength = this.length.get();
            if (binLength > (binPosition = this.position.get())) {
                int readLen = binLength - binPosition;
                readLen = readLen > len ? len : readLen;
                System.arraycopy(this.binary.get(), binPosition, out, off, readLen);
                this.position.add(readLen);
                return readLen;
            }
            if (c > 100) {
                if (System.currentTimeMillis() >= t) {
                    throw new SocketTimeoutException("\u53d7\u4fe1\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u691c\u77e5");
                }
                c = -1;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++c;
        }
    }

    public void reversePosition(int n) {
        int binPosition = this.position.get();
        if (binPosition < n) {
            throw new IllegalArgumentException("\u6307\u5b9a\u623b\u308a\u4f4d\u7f6e\u306f\u73fe\u5728\u306e\u30dd\u30b8\u30b7\u30e7\u30f3\u5024\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.position.remove(n);
    }

    public boolean isData() {
        return this.length.get() > this.position.get();
    }

    public int length() {
        int binPosition;
        int binLength = this.length.get();
        if (binLength > (binPosition = this.position.get())) {
            return binLength - binPosition;
        }
        return 0;
    }

    public boolean isUse() {
        return this.useConnectFlag.get();
    }

    private void addLimit(int len) {
        int binLength;
        int maxLength = this.binaryLength.get();
        if (maxLength <= (binLength = this.length.get()) + len) {
            int iLen = maxLength * 2 + len;
            byte[] x = new byte[iLen];
            System.arraycopy(this.binary.get(), 0, x, 0, maxLength);
            this.binary.set((Object)x);
            this.binaryLength.set(iLen);
            x = null;
        }
    }

    private boolean compact() {
        int binLength = this.length.get();
        int binPosition = this.position.get();
        if (binPosition <= 0 || binLength <= binPosition) {
            return false;
        }
        int len = binLength - binPosition;
        byte[] b = (byte[])this.binary.get();
        int i = 0;
        while (i < len) {
            b[i] = b[binPosition + i];
            ++i;
        }
        this.length.set(len);
        this.position.set(0);
        return true;
    }
}

