/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicOBJECT;

public class SendBuffer {
    private static final int BUFFER = Short.MAX_VALUE;
    private final AtomicOBJECT<byte[]> binary = new AtomicOBJECT();
    private int baseLength = 0;
    private final AtomicINT binaryLength = new AtomicINT(0);
    private final AtomicINT length = new AtomicINT(0);
    private final AtomicINT position = new AtomicINT(0);
    private final AtomicBOOL lastFlag = new AtomicBOOL(false);
    private final AtomicBOOL useConnectFlag = new AtomicBOOL(true);

    public SendBuffer() {
        this(-1);
    }

    public SendBuffer(int size) {
        if (size <= 0) {
            size = Short.MAX_VALUE;
        }
        this.baseLength = size;
        this.binaryLength.set(size);
        this.binary.set((Object)new byte[size]);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.useConnectFlag.set(false);
        this.binary.set(null);
        this.binaryLength.set(0);
    }

    public void reset() {
        if (this.useConnectFlag.get()) {
            if (this.binaryLength.get() > this.baseLength) {
                this.binary.set((Object)new byte[this.baseLength]);
                this.binaryLength.set(this.baseLength);
            }
            this.length.set(0);
            this.position.set(0);
            this.lastFlag.set(false);
        }
    }

    public boolean read(ByteBuffer buf) throws Exception {
        if (buf == null) {
            return false;
        }
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        buf.clear();
        int len = buf.limit();
        int binPosition = this.position.get();
        int nowLen = this.length.get() - binPosition;
        if (nowLen <= 0 || this.binaryLength.get() <= 0) {
            return false;
        }
        len = nowLen > len ? len : nowLen;
        buf.put((byte[])this.binary.get(), binPosition, len);
        this.position.add(len);
        buf.flip();
        return true;
    }

    public void write(int b) throws IOException {
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.addLimit(1);
        int binLength = this.length.get();
        ((byte[])this.binary.get())[binLength] = (byte)(b & 0xFF);
        this.length.inc();
    }

    public void write(byte[] bin) throws IOException {
        this.write(bin, -1);
    }

    public void write(byte[] bin, int len) throws IOException {
        if (bin == null || bin.length <= 0) {
            return;
        }
        if (len <= 0 || bin.length <= len) {
            len = bin.length;
        }
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.addLimit(len);
        int binLength = this.length.get();
        System.arraycopy(bin, 0, this.binary.get(), binLength, len);
        this.length.add(len);
    }

    public void writeHead(byte[] bin) throws IOException {
        this.writeHead(bin, -1);
    }

    public void writeHead(byte[] bin, int len) throws IOException {
        if (bin == null || bin.length <= 0) {
            return;
        }
        if (len <= 0 || bin.length <= len) {
            len = bin.length;
        }
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.addLimit(len);
        int binLength = this.length.get();
        SendBuffer.move((byte[])this.binary.get(), 0, binLength, len);
        System.arraycopy(bin, 0, this.binary.get(), 0, len);
        this.length.add(len);
    }

    public void write(ByteBuffer buf) throws Exception {
        if (buf.limit() < buf.position()) {
            buf.flip();
        }
        int len = buf.limit();
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.addLimit(len);
        int binLength = this.length.get();
        buf.get((byte[])this.binary.get(), binLength, len);
        this.length.add(len);
        buf.clear();
    }

    public void writeHead(ByteBuffer buf) throws Exception {
        if (buf.limit() < buf.position()) {
            buf.flip();
        }
        int len = buf.limit();
        if (!this.useConnectFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.addLimit(len);
        int binLength = this.length.get();
        SendBuffer.move((byte[])this.binary.get(), 0, binLength, len);
        buf.get((byte[])this.binary.get(), 0, len);
        this.length.add(len);
        buf.clear();
    }

    public void last() {
        this.lastFlag.set(true);
    }

    public boolean isLast() {
        return this.lastFlag.get();
    }

    public int length() {
        return this.length.get() - this.position.get();
    }

    public boolean isUse() {
        return this.useConnectFlag.get();
    }

    private void addLimit(int len) {
        int binLength;
        int maxLength = this.binaryLength.get();
        if (maxLength <= (binLength = this.length.get()) + len) {
            int iLen = maxLength * 2 + len;
            byte[] x = new byte[iLen];
            System.arraycopy(this.binary.get(), 0, x, 0, maxLength);
            this.binary.set((Object)x);
            this.binaryLength.set(iLen);
            x = null;
        }
    }

    private static void move(byte[] bin, int pos, int len, int moveStart) throws IOException {
        int i = len - 1;
        while (i >= 0) {
            bin[moveStart + i] = bin[pos + i];
            --i;
        }
    }
}

