/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SslUtil {
    private static final int MAX_BUFFER = 393216;
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static final SSLEngineResult unwrap(SSLEngine sslEngine, ByteBuffer buf, ByteBuffer input) throws Exception {
        buf.flip();
        SSLEngineResult ret = sslEngine.unwrap(buf, input);
        buf.compact();
        return ret;
    }

    public static final SSLEngineResult wrap(SSLEngine sslEngine, ByteBuffer buf, ByteBuffer output) throws Exception {
        if (output.capacity() > 393216) {
            throw new IOException("\u30d0\u30c3\u30d5\u30a1\u9577\u306f\u3001\u6700\u5927\u5024\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        output.clear();
        SSLEngineResult ret = sslEngine.wrap(buf, output);
        output.flip();
        return ret;
    }

    protected static final ByteBuffer reallocate(ByteBuffer buffer) throws Exception {
        if (buffer.capacity() > 393216) {
            throw new IOException("\u30d0\u30c3\u30d5\u30a1\u9577\u306f\u3001\u6700\u5927\u5024\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        ByteBuffer t = ByteBuffer.allocate(buffer.capacity() * 2);
        buffer.flip();
        t.put(buffer);
        buffer = t;
        return buffer;
    }

    public static final String[] getEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        String[] stringArray = supportedCiphers;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String supportedCipher = stringArray[n];
            String[] stringArray2 = requestedCiphers;
            int n3 = 0;
            int n4 = stringArray2.length;
            while (n3 < n4) {
                String cipher = stringArray2[n3];
                if (supportedCipher.equals(cipher = cipher.trim())) {
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(cipher);
                    break;
                }
                ++n3;
            }
            ++n;
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }
}

