/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded = false;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa10";
    private static final char atSignChar = '@';
    private static int rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:40_PST_2006";

    public OracleXADataSource() throws SQLException {
        this.isOracleDataSource = true;
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.user, this.password);
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (this.connCachingEnabled) {
            DatabaseError.throwSqlException(163);
            return null;
        }
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("user", string);
        }
        if (string2 != null) {
            properties.setProperty("password", string2);
        }
        return this.getXAConnection(properties);
    }

    public XAConnection getXAConnection(Properties properties) throws SQLException {
        return (XAConnection)this.getPooledConnection(properties);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return this.getPooledConnection(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(Properties properties) throws SQLException {
        try {
            String string = this.getURL();
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n = 0;
            if (this.useNativeXA && (string.startsWith("jdbc:oracle:oci8") || string.startsWith("jdbc:oracle:oci"))) {
                Object object;
                Class<?> clazz;
                long[] lArray = new long[]{0L, 0L};
                String string7 = null;
                String string8 = null;
                OracleXADataSource oracleXADataSource = this;
                synchronized (oracleXADataSource) {
                    string7 = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(string);
                    if (string7 != null && string7.length() == 0 || string7.startsWith("(DESCRIPTION")) {
                        DatabaseError.throwSqlException(207);
                    }
                    if (!libraryLoaded) {
                        clazz = this.getClass();
                        synchronized (clazz) {
                            if (!libraryLoaded) {
                                try {
                                    System.loadLibrary(dllName);
                                    libraryLoaded = true;
                                }
                                catch (Error error) {
                                    libraryLoaded = false;
                                    throw error;
                                }
                            }
                        }
                    }
                    if (this.connectionProperties != null) {
                        string8 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                    }
                }
                if (string8 != null && string8.equalsIgnoreCase("true")) {
                    short s = T2CConnection.getDriverCharSetIdFromNLS_LANG(null);
                    this.driverCharSetIdString = Integer.toString(s);
                } else if (!string7.equals(this.oldTnsEntry)) {
                    short s = T2CConnection.getClientCharSetId();
                    this.driverCharSetIdString = Integer.toString(s);
                    this.oldTnsEntry = string7;
                }
                OracleXADataSource oracleXADataSource2 = this;
                synchronized (oracleXADataSource2) {
                    string4 = this.databaseName + dbSuffix + rmidSeed;
                    this.rmid = n = rmidSeed;
                    clazz = this.getClass();
                    synchronized (clazz) {
                        rmidSeed = (rmidSeed + 1) % 65536;
                    }
                    int n2 = 0;
                    object = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                    this.xaOpenString = string6 = this.generateXAOpenString(string4, string7, string2, string3, 60, 2000, true, true, ".", n2, false, object != null && ((String)object).equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                    string5 = this.generateXACloseString(string4, false);
                }
                int n3 = this.doXaOpen(string6, n, 0, 0);
                if (n3 != 0) {
                    DatabaseError.throwSqlException(-1 * n3);
                }
                if ((n3 = this.convertOciHandles(string4, lArray)) != 0) {
                    DatabaseError.throwSqlException(-1 * n3);
                }
                properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                properties.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                if (this.loginTimeout != 0) {
                    properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                }
                Connection connection = this.driver.connect(this.getURL(), properties);
                object = new OracleXAHeteroConnection(connection);
                ((OraclePooledConnection)object).setUserName(string2, string3.toUpperCase());
                ((OracleXAHeteroConnection)object).setRmid(n);
                ((OracleXAHeteroConnection)object).setXaCloseString(string5);
                ((OraclePooledConnection)object).registerCloseCallback(new OracleXAHeteroCloseCallback(), object);
                return object;
            }
            if (this.thinUseNativeXA && string.startsWith("jdbc:oracle:thin")) {
                Class<?> clazz;
                Properties properties2 = new Properties();
                Serializable serializable = this;
                synchronized (serializable) {
                    clazz = this.getClass();
                    synchronized (clazz) {
                        rmidSeed = (rmidSeed + 1) % 65536;
                    }
                    this.rmid = rmidSeed;
                    if (this.connectionProperties == null) {
                        this.connectionProperties = new Properties();
                    }
                    this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                    if (string2 != null) {
                        properties2.setProperty("user", string2);
                    }
                    if (string3 != null) {
                        properties2.setProperty("password", string3);
                    }
                    properties2.setProperty("stmt_cache_size", "" + this.maxStatements);
                    properties2.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                    properties2.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                    properties2.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                serializable = new T4CXAConnection(super.getPhysicalConnection(properties2));
                ((OraclePooledConnection)serializable).setUserName(string2, string3.toUpperCase());
                clazz = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                ((OracleXAConnection)serializable).isXAResourceTransLoose = clazz != null && (((String)((Object)clazz)).equals("true") || ((String)((Object)clazz)).equalsIgnoreCase("true"));
                return serializable;
            }
            Properties properties3 = new Properties();
            Serializable serializable = this;
            synchronized (serializable) {
                if (string2 != null) {
                    properties3.setProperty("user", string2);
                }
                if (string3 != null) {
                    properties3.setProperty("password", string3);
                }
                properties3.setProperty("stmt_cache_size", "" + this.maxStatements);
                properties3.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                properties3.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                properties3.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            serializable = new OracleXAConnection(super.getPhysicalConnection(properties3));
            ((OraclePooledConnection)serializable).setUserName(string2, string3.toUpperCase());
            String string9 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            ((OracleXAConnection)serializable).isXAResourceTransLoose = string9 != null && (string9.equals("true") || string9.equalsIgnoreCase("true"));
            return serializable;
        }
        catch (XAException xAException) {
            return null;
        }
    }

    private native int doXaOpen(String var1, int var2, int var3, int var4);

    private native int convertOciHandles(String var1, long[] var2);

    synchronized void setRmid(int n) {
        this.rmid = n;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    synchronized void setXaOpenString(String string) {
        this.xaOpenString = string;
    }

    synchronized String getXaOpenString() {
        return this.xaOpenString;
    }

    private String generateXAOpenString(String string, String string2, String string3, String string4, int n, int n2, boolean bl, boolean bl2, String string5, int n3, boolean bl3, boolean bl4, String string6, String string7) {
        return new String("ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n2 + "+SESWT=" + n + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n3 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f") + (bl4 ? "+Loose_Coupling=t" : "") + "+CharSet=" + string6 + "+NCharSet=" + string7);
    }

    private String generateXACloseString(String string, boolean bl) {
        return new String("ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String getTNSEntryFromUrl(String string) {
        int n = string.indexOf(64);
        return string.substring(n + 1);
    }
}

