//
// Comet系スクリプト.
//

// コメットグループIDを取得.
getGroupId = function() {
    if( isNull( _$script$group_id ) ) {
        return null ;
    }
    return _$script$group_id ;
} ;

// スクリプトパラメータを取得.
getCometArgs = function() {
    if( isNull( _$script$comet_args ) ) {
        return null ;
    }
    return _$script$comet_args ;
} ;

// 指定グループIDのコメットを実行する.
executionGroupComet = function( groupId ) {
    if( useString( groupId ) == false ) {
        return false ;
    }
    var args = [] ;
    var len = arguments.length ;
    for( var i = 1 ; i < len ; i ++ ) {
        args[ args.length ] = arguments[ i ] ;
    }
    var comet_man = _$$maachang_comet_manager.get( "COMET_MANAGER" ) ;
    if( isNull( comet_man ) == false ) {
        commit() ;
        // グループIDに対するComet実行を行う.
        comet_man.execution( args,groupId ) ;
    }
    return true ;
}

// cometCallメソッド.
_$function$callCometAccessMethod = function() {
    if( __$type$script == "comet" ) {
        if( getHttpMethod() != "GET" ) {
            warnLog( "cometはHTTP-GETメソッド以外のアクセスを許可していません" ) ;
            exit( "error405" ) ;
        }
        var gid = getGroupId() ;
        var comentArgs = getCometArgs() ;
        var args = null ;
        // 引数を整形.
        if( isNull( comentArgs ) || valueof( comentArgs ) != "array" ) {
            args = [gid] ;
        }
        else {
            args = [gid] ;
            for( var i = 0 ; i < comentArgs.length ; i ++ ) {
                args[ args.length ] = comentArgs[ i ] ;
            }
        }
        gid = null ;
        comentArgs = null ;
        var callbackMethod = $("callback") ;
        var ret = null ;
        if( isNull( scriptMemorys.main ) ||
            valueof( scriptMemorys.main ) != "function" ) {
            warnLog( "mainメソッドは存在しないか不正です" ) ;
            exit( "error500" ) ;
        }
        try {
            ret = scriptMemorys.main.apply( null,args ) ;
            args = null ;
        } catch( e ) {
            _isExitTo() ;// スクリプト終了チェック.
            warnLog( e ) ;// 警告ログ.
            // 例外の場合、例外内容を返す.
            exit( "error500" ) ;
        }
        return jsonpResultCallBack( callbackMethod,ret ) ;
    }
    return "" ;
} ;

// triggerCallメソッド.
_$function$callTriggerAccessMethod = function() {
    if( __$type$script == "script" ) {
        if( getHttpMethod() != "GET" ) {
            warnLog( "triggerはHTTP-GETメソッド以外のアクセスを許可していません" ) ;
            exit( "error405" ) ;
        }
        var gid = $("groupId") ;
        var jargsString = $("jargs") ;
        var callbackMethod = $("callback") ;
        if( isNull( scriptMemorys.main ) ||
            valueof( scriptMemorys.main ) != "function" ) {
            warnLog( "mainメソッドは存在しないか不正です" ) ;
            exit( "error500" ) ;
        }
        else {
            var ret = null ;
            // 引数が設定されていない場合.
            if( useString( jargsString ) == false ) {
                scriptMemorys.main.apply( null,[ gid ] ) ;
            }
            // 引数が設定されている場合.
            else {
                var ta = null ;
                var args = decodeJSON( jargsString ) ;
                if( args != null ) {
                    if( valueof( args ) == "array" ) {
                        ta = [ gid ] ;
                        for( var i = 0 ; i < args.length ; i ++ ) {
                            ta[ ta.length ] = args[ i ] ;
                        }
                    }
                    else {
                        ta = [ gid,args ] ;
                    }
                }
                else {
                    ta = [ gid ] ;
                }
                args = null ;
                scriptMemorys.main.apply( null,ta ) ;
            }
        }
    }
} ;
