// ログ出力用.
// log4jを利用する.
//

// 出力チェック.
isDebugEnabled = function() {
    return log.isDebugEnabled() ;
}
isInfoEnabled = function() {
    return log.isInfoEnabled() ;
}
isWarnEnabled = function() {
    return log.isWarnEnabled() ;
}

// デバッグ出力.
debugLog = function(msg) {
    if( isNull( msg ) ) {
        return ;
    }
    log.debug( logAddMessage( msg ) ) ;
}

// 情報出力.
infoLog = function(msg) {
    if( isNull( msg ) ) {
        return ;
    }
    log.info( logAddMessage( msg ) ) ;
}

// 警告出力.
warnLog = function(msg) {
    if( isNull( msg ) ) {
        return ;
    }
    log.warn( logAddMessage( msg ) ) ;
}

// エラー出力.
errorLog = function(msg) {
    if( isNull( msg ) ) {
        return ;
    }
    log.error( logAddMessage( msg ) ) ;
}

// リクエストが有効の場合の付加処理.
logAddMessage = function(msg) {
    if( isRequest() ) {
        return new StrBuf().
            ad( "##[" ).ad( _$script$request.getRemoteAddress() ).
            ad( ":" ).ad( _$script$request.getRemotePort() ).ad( "] url:" ).
            ad( _$script$request.getUrlPath() ).ad( "] " ).ad( msg ).ts() ;
    }
    return msg ;
}

