///////////////////////////////////////////////////////////////////////////////
// maachangComet 基本Javascript.
// Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

// グローバル.
__VAL_GLOVAL__ = this ;

// ブラウザ判別.
var isMSIE = /*@cc_on!@*/false; 
var isSAFARI = navigator.userAgent.indexOf( "Safari" ) != -1 ;
var isOPERA = navigator.userAgent.indexOf( "Opera" ) != -1 ;
var isMOZILLA = navigator.userAgent.indexOf( "Mozilla/" ) != -1 && isMSIE == false ;
var isNETSCAPE = navigator.userAgent.indexOf( "Netscape" ) != -1 ;
var isCHROME = navigator.userAgent.indexOf( "Chrome/" ) != -1 ;

// クッキー判別.
var isCookie = navigator.cookieEnabled ;

// maachangSessionId.
var SESSION_ID = "$@@SESSION_ID@@" ;
var HTTP_URL = "$@@HTTP_URL@@" ;
var HTTPS_URL = "$@@HTTPS_URL@@" ;

///////////////////////////////////////////////////////////////////////////////
// 基本定義.
///////////////////////////////////////////////////////////////////////////////

// getElementById.
$ = function( name ) {
    return document.getElementById( name ) ;
} ;

// bind.
Function.prototype.bind = function(object) {
    var md = this;
    return (function() {
        return md.apply(object, arguments);
    }) ;
} ;

// firefox専用デバッグ出力.
dbg = function( str ) {
    if( isMOZILLA == true && $base.isNull( console ) == false ) {
        console.debug( str ) ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// baseオブジェクト.
///////////////////////////////////////////////////////////////////////////////
$base = {
    // nullチェック.
    isNull : function( value ) {
        if( value == null || typeof( value ) == "undefined" ) {
            return true ;
        }
        return false ;
    },
    // trim.
    trim : function(arg_value){
        if( this.isNull( arg_value ) == true ||
            arg_value.length <= 0 ) {
            return '' ;
        }
        else if( typeof( arg_value ) != "string" ) {
            return arg_value ;
        }
        for( i = 0; i < arg_value.length ; i ++ ) {
            var old = arg_value ;
            arg_value = arg_value.replace( "&nbsp;"," " ) ;
            if( old.length == arg_value.length ) {
                break ;
            }
        }
        
        var st = 0 ;
        var ed = arg_value.length ;
        var len = arg_value.length ;
        for( i = 0 ; i < len ; i ++ ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || x == 160 ) {//x==160はsafari対応.
                st = i+1 ;
            }
            else {
                break ;
            }
        }
        len = arg_value.length-1 ;
        for( i = len ; i >= 0 ; i -- ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || x == 160 ) {//x==160はsafari対応.
                ed = i ;
            }
            else {
                break ;
            }
        }
        if( st >= ed ) {
            return '' ;
        }
        ret = arg_value.substring( 0,ed ) ;
        if( st > 0 ) {
            ret = ret.substring( st ) ;
        }
        return ret ;
    },
    // 文字列を置き換える.
    changeString : function( base,src,dest ) {
        if( this.isNull( base ) ||
            this.isNull( src ) ||
            this.isNull( dest ) ) {
            return "" ;
        }
        // すべての文字列を置き換えるように変更.
        for( ;; ) {
            var ret = '' ;
            var p = base.indexOf( src ) ;
            if( p == -1 ) {
                return base ;
            }
            if( p == 0 ) {
                ret += dest ;
                ret += base.substring( src.length,base.length ) ;
            }
            else {
                ret += base.substring( 0,p ) ;
                ret += dest ;
                if( src.length != base.length ) {
                    ret += base.substring( p+src.length,base.length ) ;
                }
            }
            base = ret ;
            ret = "" ;
        }
    },
    // startWith.
    startsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        if( str.indexOf( chk ) == 0 ) {
            return true ;
        }
        return false ;
    },
    // endsWith.
    endsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        var last = str.lastIndexOf( chk ) ;
        if( last != -1 && last == str.length-chk.length ) {
            return true ;
        }
        return false ;
    },
    // 文字存在チェック.
    useString : function(str){
        if( this.isNull( str ) == true || this.trim(str).length <= 0 ) {
            return false ;
        }
        return true ;
    },
    // 数値チェック.
    isNumeric : function(num){
        if( this.useString( num ) == false ) {
            return false ;
        }
        if( this.startsWith( num,"-" ) ) {
            num = num.substring( 1 ) ;
        }
        if (num.match(/[^0-9.0-9]/g)) {
            return false;
        }
        return true;
    },
    // 現在日付を取得
    nowDateString : function(mode) {
        return this.formatDateByString(new Date(),mode) ;
    },
    // 日付を変換.
    formatDateByString : function( date,mode ) {
        if( this.isNull( date ) ) {
            return null ;
        }
        if( this.isNull( mode ) ) {
            mode = false ;
        }
        var ret = "" + date.getFullYear() ;
        var x = ""+(date.getMonth()+1) ;
        ret += "/" + "00".substring( x.length,2 ) + x ;
        x = ""+date.getDate() ;
        ret += "/" + "00".substring( x.length,2 ) + x ;
        if( mode == true ) {
            ret += " " ;
        }
        else {
            ret += "&nbsp;" ;
        }
        x = ""+date.getHours() ;
        ret += "00".substring( x.length,2 ) + x ;
        x = ""+date.getMinutes() ;
        ret += ":" + "00".substring( x.length,2 ) + x ;
        x = ""+date.getSeconds() ;
        ret += ":" + "00".substring( x.length,2 ) + x ;
        return ret ;
    },
    // 文字をエンコード.
    encodeParam : function(params) {
        if( this.useString( params ) == true ) {
            var x = params.split( "&" ) ;
            var len = x.length ;
            var ret = "" ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( i != 0 ) {
                    ret += "&" ;
                }
                var p = x[i].indexOf( "=" ) ;
                if( p != -1 ) {
                    var k = x[i].substring( 0,p ) ;
                    var v = x[i].substring( p+1,x[i].length ) ;
                    x[i] = k + "=" + encodeURIComponent( v ) ;
                }
                ret += x[i] ;
            }
        }
        return ret ;
    },
    // ＧＥＴパラメータを整形.
    trimGetParams : function( params ) {
        if( isCookie == false ) {
            if( this.useString( params ) ) {
                params += "&_maachang-session=" + SESSION_ID ;
            }
            else {
                params = "_maachang-session=" + SESSION_ID ;
            }
        }
        return params ;
    },
    // 現在のURLを取得.
    getURL : function() {
        return "$@@URL@@" ;
        //return document.URL ;
    },
    // 現在のURLから、ドメイン名までを取得.
    getUrlDomain : function() {
        var url = this.getURL() ;
        var p = url.indexOf( "//" ) ;
        if( p <= -1 ) {
            return "" ;
        }
        p = url.indexOf( "/",p+"//".length ) ;
        if( p <= -1 ) {
            return url ;
        }
        return url.substring( 0,p+"/".length ) ;
    },
    // 現在のドメインだけを取得.
    getDomain : function() {
        var url = this.getURL() ;
        var p = url.indexOf( "//" ) ;
        if( p <= -1 ) {
            return "" ;
        }
        var p1 = url.indexOf( "/",p+"//".length ) ;
        if( p1 <= -1 ) {
            return url.substring( p+"//".length ) ;
        }
        return url.substring( p+"//".length,p1 ) ;
    },
    // URLパラメータに対して、クッキー非対応の場合のセッションID付加処理.
    addNoCookieBySession : function( params ) {
        // クッキ非対応の場合.
        if( isCookie == false ) {
            if( $base.isNull( params ) ) {
                params = "" ;
            }
            if( $base.useString( params ) ) {
                params += "&_maachang-session=" + SESSION_ID ;
            }
            else {
                params += "_maachang-session=" + SESSION_ID ;
            }
        }
        return params ;
    },
    // チェック処理に対して日付計算を行ってoptionを再生成.
    changeSelectYMD : function( name ) {
        if( this.useString( $( name+"YearId" ).value ) == false ||
            this.useString( $( name+"MonthId" ).value ) == false ) {
            $( name+"DayId" ).innerHTML = "<option value=\"\">選択" ;
            return ;
        }
        var y = parseInt( $( name+"YearId" ).value ) ;
        var m = parseInt( $( name+"MonthId" ).value ) ;
        var st = new Date( y,m-1,1,0,0,0 ).getTime() ;
        m = m + 1 ;
        if( m > 12 ) {
            m = 1 ;
            y ++ ;
        }
        var ed = new Date( y,m-1,1,0,0,0 ).getTime() ;
        var tm = ed-st ;
        var len = tm / ( new Date( 0,0,2,0,0,0 ).getTime()-new Date( 0,0,1,0,0,0 ).getTime() );
        var str = "" ;
        var selectDay = parseInt( $( name+"DayId" ).value ) ;
        if( $base.isNull( selectDay ) ) {
            for( var i = 0 ; i < len ; i ++ ) {
                var x = ""+(i+1) ;
                x = "00".substring( x.length )+x ;
                str += "<option value=\""+(i+1)+"\">"+x ;
            }
        }
        else {
            for( var i = 0 ; i < len ; i ++ ) {
                var x = ""+(i+1) ;
                x = "00".substring( x.length )+x ;
                if( selectDay != i+1 ) {
                    str += "<option value=\""+(i+1)+"\">"+x ;
                }
                else {
                    str += "<option value=\""+(i+1)+"\" selected>"+x ;
                }
            }
        }
        $( name+"DayId" ).innerHTML = str ;
    },
    // HTML表示可能な形式に変換.
    changeStringByHTML : function( string ) {
        var len = string.length ;
        var ret = "" ;
        for( var i = 0 ; i < len ; i ++ ) {
            var c = string.charAt( i ) ;
            if( c == "&" ) {
                ret += "&amp;" ;
            }
            else if( c == "<" ) {
                ret += "&lt;" ;
            }
            else if( c == ">" ) {
                ret += "&gt;" ;
            }
            else if( c == "\'" ) {
                ret += "&#039;" ;
            }
            else if( c == "\"" ) {
                ret += "&#034;" ;
            }
            else {
                ret += c ;
            }
        }
        return ret ;
    }
} ;

// stringオブジェクト拡張用.
String.prototype.startsWith = function( s ) {
    return $base.startsWith( this,s ) ;
}
String.prototype.endsWith = function( s ) {
    return $base.endsWith( this,s ) ;
}
String.prototype.trim = function() {
    return $base.trim( this ) ;
}
String.prototype.change = function( src,dest ) {
    return $base.changeString( this,src,dest ) ;
}

///////////////////////////////////////////////////////////////////////////////
// 例外オブジェクト.
///////////////////////////////////////////////////////////////////////////////

// 基本例外.
Exception = function(message) {
    this.name = "Exception" ;
    if( $base.useString( message ) ) {
        this.message = message ;
    }
    else {
        this.message = "" ;
    }
} ;
Exception.prototype = new Error;
Exception.prototype.toString = function() {
    if( $base.useString( this.message ) ) {
        return "["+this.name+"] :message "+this.message ;
    }
    return "["+this.name+"]"
} ;

// NullPointerException.
NullPointerException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
NullPointerException.prototype = new Exception;
NullPointerException.prototype.name = 'NullPointerException';


// IllegalArgumentException.
IllegalArgumentException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IllegalArgumentException.prototype = new Exception;
IllegalArgumentException.prototype.name = 'IllegalArgumentException';


// IndexOutOfBoundsException.
IndexOutOfBoundsException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IndexOutOfBoundsException.prototype = new Exception;
IndexOutOfBoundsException.prototype.name = 'IndexOutOfBoundsException';


// IOException.
IOException = function(message){
    if( $base.useString( message ) ) {
        this.message = message;
    }
    else {
        this.message = "";
    }
};
IOException.prototype = new Exception;
IOException.prototype.name = 'IOException';

///////////////////////////////////////////////////////////////////////////////
// デバッグ系.
///////////////////////////////////////////////////////////////////////////////
$debug = {
    // 最大出力文字数.
    maxlength: 65535,
    // element設定フラグ.
    elementFlag: false,
    // デバッグ出力.
    out : function( value ) {
        if( $base.useString( value ) == false ) {
            return ;
        }
        // firefoxの場合は、コンソールに出力.
        if( this.elementFlag == false && isMOZILLA == true ) {
            dbg( "[" + $base.nowDateString() + "] : # " + value + "    " ) ;
        }
        // それ以外の場合は、element設定した内容に出力.
        else {
            $('debugId').innerHTML = "[" + $base.nowDateString() + "]&nbsp;:&nbsp;#&nbsp;" +
                value + "&nbsp;&nbsp;&nbsp;&nbsp;<br>" + $('debugId').innerHTML ;
            var c = $('debugId').innerHTML ;
            if( c.length > this.maxlength ) {
                $('debugId').innerHTML = c.substring( 0,maxlength ) ;
            }
        }
    },
    // デバッグ出力位置を設定.
    element : function(mode) {
        debugTag = document.createElement('div') ;
        debugTag.id="debugId";
        if( $base.isNull( mode ) == false && mode == true ) {
            document.body.appendChild(debugTag) ;
        }
        this.elementFlag = true ;
        return debugTag ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// md5処理.
///////////////////////////////////////////////////////////////////////////////

$md5 = {
    TABLE : new Array(0x00000000, 0xd76aa478, 0xe8c7b756, 0x242070db,
                  0xc1bdceee, 0xf57c0faf, 0x4787c62a, 0xa8304613,
                  0xfd469501, 0x698098d8, 0x8b44f7af, 0xffff5bb1,
                  0x895cd7be, 0x6b901122, 0xfd987193, 0xa679438e,
                  0x49b40821, 0xf61e2562, 0xc040b340, 0x265e5a51,
                  0xe9b6c7aa, 0xd62f105d, 0x02441453, 0xd8a1e681,
                  0xe7d3fbc8, 0x21e1cde6, 0xc33707d6, 0xf4d50d87,
                  0x455a14ed, 0xa9e3e905, 0xfcefa3f8, 0x676f02d9,
                  0x8d2a4c8a, 0xfffa3942, 0x8771f681, 0x6d9d6122,
                  0xfde5380c, 0xa4beea44, 0x4bdecfa9, 0xf6bb4b60,
                  0xbebfbc70, 0x289b7ec6, 0xeaa127fa, 0xd4ef3085,
                  0x04881d05, 0xd9d4d039, 0xe6db99e5, 0x1fa27cf8,
                  0xc4ac5665, 0xf4292244, 0x432aff97, 0xab9423a7,
                  0xfc93a039, 0x655b59c3, 0x8f0ccc92, 0xffeff47d,
                  0x85845dd1, 0x6fa87e4f, 0xfe2ce6e0, 0xa3014314,
                  0x4e0811a1, 0xf7537e82, 0xbd3af235, 0x2ad7d2bb,
                  0xeb86d391),
    ROUND : [
        [function(x, y, z) { return (x & y) | (~x & z); },
        new Array(new Array( 0, 7, 1), new Array( 1,12, 2),
               new Array( 2,17, 3), new Array( 3,22, 4),
               new Array( 4, 7, 5), new Array( 5,12, 6),
               new Array( 6,17, 7), new Array( 7,22, 8),
               new Array( 8, 7, 9), new Array( 9,12,10),
               new Array(10,17,11), new Array(11,22,12),
               new Array(12, 7,13), new Array(13,12,14),
               new Array(14,17,15), new Array(15,22,16)) ],
        [function(x, y, z) { return (x & z) | (y & ~z); },
        new Array(new Array( 1, 5,17), new Array( 6, 9,18),
               new Array(11,14,19), new Array( 0,20,20),
               new Array( 5, 5,21), new Array(10, 9,22),
               new Array(15,14,23), new Array( 4,20,24),
               new Array( 9, 5,25), new Array(14, 9,26),
               new Array( 3,14,27), new Array( 8,20,28),
               new Array(13, 5,29), new Array( 2, 9,30),
               new Array( 7,14,31), new Array(12,20,32)) ],
        [function(x, y, z) { return x ^ y ^ z;          },
        new Array(new Array( 5, 4,33), new Array( 8,11,34),
               new Array(11,16,35), new Array(14,23,36),
               new Array( 1, 4,37), new Array( 4,11,38),
               new Array( 7,16,39), new Array(10,23,40),
               new Array(13, 4,41), new Array( 0,11,42),
               new Array( 3,16,43), new Array( 6,23,44),
               new Array( 9, 4,45), new Array(12,11,46),
               new Array(15,16,47), new Array( 2,23,48)) ],
        [function(x, y, z) { return y ^ (x | ~z);       },
        new Array(new Array( 0, 6,49), new Array( 7,10,50),
               new Array(14,15,51), new Array( 5,21,52),
               new Array(12, 6,53), new Array( 3,10,54),
               new Array(10,15,55), new Array( 1,21,56),
               new Array( 8, 6,57), new Array(15,10,58),
               new Array( 6,15,59), new Array(13,21,60),
               new Array( 4, 6,61), new Array(11,10,62),
               new Array( 2,15,63), new Array( 9,21,64)) ]],
    pack : function(n32) {
      return String.fromCharCode(n32 & 0xff) +
         String.fromCharCode((n32 >>> 8) & 0xff) +
         String.fromCharCode((n32 >>> 16) & 0xff) +
         String.fromCharCode((n32 >>> 24) & 0xff)
    },
    unpack : function(s4) {
      return  s4.charCodeAt(0)        |
         (s4.charCodeAt(1) <<  8) |
         (s4.charCodeAt(2) << 16) |
         (s4.charCodeAt(3) << 24);
    },
    number : function(n) {
      while (n < 0)
        n += 4294967296;
      while (n > 4294967295)
        n -= 4294967296;
      return n;
    },
    apply_round : function(x, s, f, abcd, r) {
      var a, b, c, d;
      var kk, ss, ii;
      var t, u;
      a = abcd[0];
      b = abcd[1];
      c = abcd[2];
      d = abcd[3];
      kk = r[0];
      ss = r[1];
      ii = r[2];
      u = f(s[b], s[c], s[d]);
      t = s[a] + u + x[kk] + this.TABLE[ii];
      t = this.number(t);
      t = ((t<<ss) | (t>>>(32-ss)));
      t += s[b];
      s[a] = this.number(t);
    },
    hash : function(data) {
      var abcd, x, state, s;
      var len, index, padLen, f, r;
      var i, j, k;
      var tmp;
      
      state = new Array(0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476);
      len = data.length;
      index = len & 0x3f;
      padLen = (index < 56) ? (56 - index) : (120 - index);
      if(padLen > 0) {
        data += "\x80";
        for(i = 0; i < padLen - 1; i++)
          data += "\x00";
      }
      data += this.pack(len * 8);
      data += this.pack(0);
      len  += padLen + 8;
      abcd = new Array(0, 1, 2, 3);
      x    = new Array(16);
      s    = new Array(4);
      
      for(k = 0; k < len; k += 64) {
        for(i = 0, j = k; i < 16; i++, j += 4) {
          x[i] = data.charCodeAt(j) |
            (data.charCodeAt(j + 1) <<  8) |
            (data.charCodeAt(j + 2) << 16) |
            (data.charCodeAt(j + 3) << 24);
        }
        for(i = 0; i < 4; i++)
          s[i] = state[i];
        for(i = 0; i < 4; i++) {
          f = this.ROUND[i][0];
          r = this.ROUND[i][1];
          for(j = 0; j < 16; j++) {
            this.apply_round(x, s, f, abcd, r[j]);
            tmp = abcd[0];
            abcd[0] = abcd[3];
            abcd[3] = abcd[2];
            abcd[2] = abcd[1];
            abcd[1] = tmp;
          }
        }
        for(i = 0; i < 4; i++) {
          state[i] += s[i];
          state[i] = this.number(state[i]);
        }
      }
      return this.pack(state[0]) +
         this.pack(state[1]) +
         this.pack(state[2]) +
         this.pack(state[3]);
    },
    hexhash : function(data) {
        var i, out, c;
        var bit128;
        
        bit128 = this.hash(data);
        out = "";
        for(i = 0; i < 16; i++) {
        c = bit128.charCodeAt(i);
        out += "0123456789abcdef".charAt((c>>4) & 0xf);
        out += "0123456789abcdef".charAt(c & 0xf);
        }
        return out;
    }
} ;

// md5変換内容を文字列で取得するメソッド.
md5 = function( data ) {
    return $md5.hexhash( data ) ;
} ;

///////////////////////////////////////////////////////////////////////////////
// 文字列連結オブジェクト.
///////////////////////////////////////////////////////////////////////////////
StrBuf = function( str ) {
    this.buf = [] ;
    this.bufLen = 0 ;
    if( $base.useString( str ) == false ) {
        return this ;
    }
    this.buf.push( str ) ;
    this.bufLen += str.length ;
    return this ;
}
StrBuf.prototype = {
    // buffer.
    buf: [],
    // length.
    bufLen : 0,
    // 生成処理.
    create: function( str ) {
        this.clear() ;
        return this.append( str ) ;
    },
    // クリア処理.
    clear: function() {
        this.buf = [] ;
        this.bufLen = 0 ;
        return this ;
    },
    // 連結.
    ad: function(str) {
        if( $base.useString( str ) == false ) {
            return this ;
        }
        this.buf.push( str ) ;
        this.bufLen += str.length ;
        return this ;
    },
    append: function(str) {
        if( $base.useString( str ) == false ) {
            return this ;
        }
        this.buf.push( str ) ;
        this.bufLen += str.length ;
        return this ;
    },
    // 長さを取得.
    length: function() {
        return this.bufLen ;
    },
    // 内容表示.
    ts: function() {
        if( this.buf.length <= 0 ) {
            return "" ;
        }
        return this.buf.join("") ;
    },
    // 内容表示.
    toString: function() {
        if( this.buf.length <= 0 ) {
            return "" ;
        }
        return this.buf.join("") ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// Ajaxアクセス処理.
///////////////////////////////////////////////////////////////////////////////
accessAjax = function( url,sendParams,callFunc ) {
    // Ajaxオブジェクトを生成.
    var xmlhttp = null ;
    if(window.ActiveXObject) {
        try {
            xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            xmlhttp = null ;
        }
        if( $base.isNull( xmlhttp ) ) {
            try {
                xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e) {
                xmlhttp = null;
            }
        }
    }
    else if(window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    }
    if( $base.isNull( xmlhttp ) ) {
        xmlhttp = new XMLHttpRequest();
        if( isNull( xmlhttp ) ) {
            xmlhttp = null ;
        }
    }
    if( $base.isNull( xmlhttp ) ) {
        return "" ;
    }
    var sync = ( $base.isNull( callFunc ) ) ? "false" : "true" ;
    
    // クッキ非対応の場合.
    sendParams = $base.addNoCookieBySession( sendParams ) ;
    // パラメータが存在する場合.
    if( $base.useString( sendParams ) ) {
        // コネクションオープン.
        xmlhttp.open("POST",url,sync);
        
        // POST用ContentTypeをセット.
        try {
            if( typeof( xmlhttp.setRequestHeader ) == 'function' ) {
                xmlhttp.setRequestHeader( "Content-Type",
                    "application/x-www-form-urlencoded; charset=UTF-8" ) ;
            }
        } catch( e ) {
        }
    }
    else {
        // コネクションオープン.
        xmlhttp.open("GET",url,sync);
    }
    
    // 非同期処理の場合.
    if( sync == "true" ) {
        xmlhttp.onreadystatechange = function() {
            if( xmlhttp.readyState == 4 ) {
                try {
                    // 正常処理.
                    if( xmlhttp.status == 200 ) {
                        var result = xmlhttp.responseText ;
                        callFunc( result ) ;
                    }
                } catch( e ) {
                    // エラー処理.
                    callFunc( [{result:"error",value:e.toString()}] ) ;
                }
                // 接続処理終了.
                try {
                    xmlhttp.abort() ;
                } catch( e ) {
                }
                xmlhttp = null ;
            }
        }
    }
    // 送信処理.
    if( $base.useString( sendParams ) == false ) {
        xmlhttp.send( null ) ;
    }
    else {
        xmlhttp.send(sendParams) ;
    }
    // 同期処理の場合.
    if( sync == "false" ) {
        var result = xmlhttp.responseText ;
        // 接続処理終了.
        try {
            xmlhttp.abort() ;
        } catch( e ) {
        }
        xmlhttp = null ;
        return result ;
    }
    return "" ;
} ;

///////////////////////////////////////////////////////////////////////////////
// json変換.
///////////////////////////////////////////////////////////////////////////////
$json = {
    // json形式に変換.
    encode : function( value ) {
        if( $base.isNull( value ) ) {
            return "[\"\"]" ;
        }
        var t = valueof( value ) ;
        if( t == "array" ) {
            return this.evalByArrayString( ret,value ) ;
        }
        else if( t == "map" ) {
            t = null ;
            var ret = "[" ;
            this.evalByMapString( ret,value ) ;
            return ret + "]" ;
        }
        return "["+this.evalByString( t,value )+"]" ;
    },
    // json形式の文字列を変換.
    decode : function( value ) {
        if( $base.isNull( value ) || typeof( value ) != "string" ) {
            return null ;
        }
        var ret = eval( value ) ;
        if( $base.isNull( ret ) != null ) {
            if( this.valueof( ret ) == "array" && ret.length == 1 ) {
                ret = ret[ 0 ] ;
            }
            return ret ;
        }
        return null ;
    },
    // Arrayタイプから、eval実行可能内容を生成.
    evalByArrayString : function( o,v ) {
        o += "[" ;
        var len = v.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                o += "," ;
            }
            var t = this.valueof( v[i] ) ;
            if( t == "array" ) {
                o = this.evalByArrayString( o,v[i] ) ;
            }
            else if( t == "map" ) {
                o = this.evalByMapString( o,v[i] ) ;
            }
            else {
                o += this.evalByString( t,v[i] ) ;
            }
        }
        return o + "]" ;
    },
    // Mapタイプから、eval実行可能内容を生成.
    evalByMapString : function( o,v ) {
        o += "{" ;
        var cnt = 0 ;
        for( var k in v ) {
            if( cnt != 0 ) {
                o += "," ;
            }
            o += "\"" + k + "\":" ;
            var t = this.valueof( v[k] ) ;
            if( t == "array" ) {
                o = this.evalByArrayString( o,v[k] ) ;
            }
            else if( t == "map" ) {
                o = this.evalByMapString( o,v[k] ) ;
            }
            else {
                o += this.evalByString( t,v[k] ) ;
            }
            cnt ++ ;
        }
        return o + "}" ;
    },
    // 指定タイプから、eval実行可能内容を生成.
    evalByString : function( t,v ) {
        if( t == "string" ) {
            return "\""+this.stringByCote( v )+"\"" ;
        }
        else if( t == "boolean" ) {
            return ""+v ;
        }
        else if( t == "number" ) {
            return ""+v ;
        }
        else if( t == "date" ) {
            return "new Date(" + v.getTime() + ")" ;
        }
        return "\"\"" ;
    },
    // 指定内容タイプを取得.
    valueof : function( val ) {
        if( $base.isNull( val ) ) {
            return "null" ;
        }
        var t = typeof( val ) ;
        if( t == "string" ) {
            return "string" ;
        }
        if( t == "boolean" ) {
            return "boolean" ;
        }
        else if( t == "number" ) {
            return "number" ;
        }
        else if( t == "function" ) {
            return "function" ;
        }
        else if( t == "object" ) {
            if( val instanceof Date ) {
                return "date" ;
            }
            else if( val instanceof Array ) {
                if( val.length == 0 ) {
                    return "array" ;
                }
                return this.arrayOrMapValueTo( val ) ;
            }
        }
        return this.arrayOrMapValueTo( val ) ;
    },
    // 指定内容タイプがArrayかMapか取得.
    arrayOrMapValueTo : function( val ) {
        /*var cnt = 0 ;
        var aryFlg = true ;
        for( var k in val ) {
            if( cnt != k ) {
                cnt ++ ;
                aryFlg = false ;
                break ;
            }
            cnt ++ ;
        }
        if( cnt == 0 ) {
            return "object" ;
        }
        if( aryFlg == true ) {
            return "array" ;
        }
        return "map" ;*/
        if( typeof( val.length ) == "number" ) {
            return "array" ;
        }
        for( var k in val ) {
            return "map" ;
        }
        return "object" ;
    },
    // 文字列内のコーテーション対応.
    stringByCote : function( val ) {
        var len = val.length ;
        var yen = 0 ;
        var ret = "" ;
        for( var i = 0 ; i < len ; i ++ ) {
            var c = val.charAt( i ) ;
            if( c == '\\' ) {
                yen ++ ;
                ret += c ;
            }
            else if( c == '\"' ) {
                if( yen > 0 ) {
                    ret += "\\\\" ;
                }
                else {
                    ret += "\\" ;
                }
                yen = 0 ;
                ret += c ;
            }
            else {
                yen = 0 ;
                ret += c ;
            }
        }
        return ret ;
    }
} ;

// typeof拡張.
valueof = function(value) {
    return $json.valueof(value) ;
} ;

///////////////////////////////////////////////////////////////////////////////
// jsonpオブジェクト.
///////////////////////////////////////////////////////////////////////////////

$jsonp = {
    // jsonp実行処理.
    execution : function(url,cb,arg,jmap) {
        if( $base.useString( url ) == false ) {
            throw new IllegalArgumentException( "urlが指定されていません" ) ;
        }
        // パラメータ引数をJSON形式に変換.
        if( $base.isNull( arg ) || valueof( arg ) != "array" ) {
            arg = null ;
        }
        var params = new StrBuf() ;
        // JSONP引数.
        if( $base.isNull( arg ) == false && arg.length > 0 ) {
            params.ad( "jargs=" ).ad( encodeURIComponent( $json.encode( arg ) ) ) ;
        }
        else {
            params.ad( "jargs=" ) ;
        }
        // コールバックメソッドが存在する場合、その内容をパラメータとしてセット.
        if( $base.useString( cb ) ) {
            params.ad( "&callback=" ).ad( encodeURIComponent(cb) ) ;
        }
        if( $base.isNull( jmap ) == false && valueof( jmap ) == 'map' ) {
            for( var k in jmap ) {
                params.ad( "&" ).ad( k ).ad( "=" ).ad( jmap[ k ] ) ;
            }
        }
        return this.send( url,null,null,params.ts() ) ;
    },
    // jsonp.
    send : function( url,id,name,params ) {
        if( $base.useString( url ) == false ) {
            throw new IllegalArgumentException(
                "接続先(url)を指定してください" ) ;
        }
        if( $base.useString( params ) ) {
            url += "?" + params ;
        }
        var script = document.createElement('script') ;
        script.charset = 'utf-8' ;
        if( $base.useString( id ) ) {
            script.id = id ;
        }
        if( $base.useString( name ) ) {
            script.name = name ;
        }
        // url名に整形.
        if( $base.startsWith( url,"http://" ) == false &&
            $base.startsWith( url,"https://" ) == false ) {
            if( url.startsWith( "/" ) == false ) {
                url = "/" + url ;
            }
            // 現在の接続プロトコルに合った通信を行う.
            if( document.location.protocol == "http:" ) {
                url = HTTP_URL + url ;
            }
            else {
                url = HTTPS_URL + url ;
            }
        }
        if( url.indexOf( "?" ) == -1 ) {
            url += "?t=" + new Date().getTime() ;
        }
        else {
            url += "&t=" + new Date().getTime() ;
        }
        if( url.indexOf( "://"+$base.getDomain() ) != -1 ) {
            url = $base.addNoCookieBySession( url ) ;
        }
        script.src = url ;
        // script呼び出し.
        document.body.appendChild(script) ;
        return url ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// RPCオブジェクト.
///////////////////////////////////////////////////////////////////////////////

$rpc = {
    _methodCounter : 0,
    // jsonpサーバリソースにアクセスするメソッド生成.
    createFunction : function( url,callFunc ) {
        if( $base.useString( url ) == false || typeof( url ) != "string" ||
            url.endsWith( ".mhtml" ) || url.endsWith( "mttml" ) ) {
            throw new IllegalArgumentException( "urlは不正です" ) ;
        }
        if( $base.isNull( callFunc ) || typeof( callFunc ) != "function" ) {
            throw new IllegalArgumentException( "callFuncは不正です" ) ;
        }
        if( url.endsWith( ".ms" ) ) {
            url = url.substring( 0,url.length-".ms".length ) ;
        }
        if( url.endsWith( "/" ) ) {
            url += "index" ;
        }
        if( url.endsWith( "Rpc" ) == false ) {
            url += "Rpc" ;
        }
        // コールバックメソッドをセット.
        var callbackName = "_rs_rpc"+this._methodCounter+"_"+new Date().getTime() ;
        this._methodCounter ++ ;
        eval( callbackName + "=" + callFunc.toString() ) ;
        callFunc = null ;
        // 実行メソッドを生成して戻す.
        return (function() {
            // パラメータ引数をJSON形式に変換.
            var jargs = [] ;
            for( var i = 0 ; i < arguments.length ; i ++ ) {
                jargs[ jargs.length ] = arguments[ i ] ;
            }
            $jsonp.execution( url,callbackName,jargs,null ) ;
        }) ;
    }
} ;

///////////////////////////////////////////////////////////////////////////////
// Cometオブジェクト.
///////////////////////////////////////////////////////////////////////////////

$comet = {
    _methodCounter : 0,
    // comet開始処理.
    startComet : function( url,gid,callFunc ) {
        if( $base.useString( url ) == false || typeof( url ) != "string" ||
            url.endsWith( ".mhtml" ) || url.endsWith( "mttml" ) ) {
            throw new IllegalArgumentException( "urlは不正です" ) ;
        }
        if( $base.isNull( callFunc ) || typeof( callFunc ) != "function" ) {
            throw new IllegalArgumentException( "callFuncは不正です" ) ;
        }
        if( url.endsWith( ".ms" ) ) {
            url = url.substring( 0,url.length-".ms".length ) ;
        }
        if( url.endsWith( "/" ) ) {
            url += "index" ;
        }
        if( url.endsWith( "Comet" ) == false ) {
            url += "Comet" ;
        }
        if( $base.useString( gid ) == false ) {
            gid = md5( url.substring( 0,url.length-"Comet".length ) ) ;
        }
        if( gid.startsWith( "gid_" ) == false ) {
            gid = "gid_" + gid ;
        }
        // コールバックメソッド名を生成.
        var callbackName = "_rs_cmt"+this._methodCounter+"_"+new Date().getTime() ;
        this._methodCounter ++ ;
        // コールバックメソッドを改竄.
        var funcStr = callFunc.toString() ;
        callFunc = null ;
        var p = funcStr.lastIndexOf( "}" ) ;
        // 改竄コールバックメソッドをセット.
        funcStr = new StrBuf().ad( callbackName ).ad( " = " ).ad( funcStr.substring( 0,p ) ).
            ad( "\n    $jsonp.execution(\"" ).ad( url ).ad( "\",\"" ).
            ad( callbackName ).ad( "\",null,{groupId:\"" ).
            ad( gid ).ad( "\"});\n}" ).ts() ;
        eval( funcStr ) ;
        funcStr = null ;
        $jsonp.execution( url,callbackName,null,{groupId:gid} ) ;
    },
    // cometトリガー実行用メソッドを生成.
    triggerFunction : function( url,gid ) {
        if( $base.useString( url ) == false || typeof( url ) != "string" ||
            url.endsWith( ".mhtml" ) || url.endsWith( "mttml" ) ) {
            throw new IllegalArgumentException( "urlは不正です" ) ;
        }
        if( url.endsWith( ".ms" ) ) {
            url = url.substring( 0,url.length-".ms".length ) ;
        }
        if( url.endsWith( "/" ) ) {
            url += "index" ;
        }
        if( url.endsWith( "Trigger" ) == false ) {
            url += "Trigger" ;
        }
        if( $base.useString( gid ) == false ) {
            gid = md5( url.substring( 0,url.length-"Trigger".length ) ) ;
        }
        if( gid.startsWith( "gid_" ) == false ) {
            gid = "gid_" + gid ;
        }
        // 実行メソッドを生成して戻す.
        return (function() {
            // パラメータ引数をJSON形式に変換.
            var jargs = [] ;
            for( var i = 0 ; i < arguments.length ; i ++ ) {
                jargs[ jargs.length ] = arguments[ i ] ;
            }
            $jsonp.execution( url,null,jargs,{"groupId":gid} ) ;
        }) ;
    }
}


