///////////////////////////////////////////////////////////////////////////////
// maachangCometHTML系の処理メソッド.
// Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// ブラウザ系.
////////////////////////////////////////////////////////////////////////////////

// URL遷移(リダイレクト).
forwardURL = function( url ) {
    if( $base.useString( url ) == true ) {
        window.location = url ;
    }
} ;

// GETパラメータを取得.
$getParams = function() {
    this.params = {} ;
    var s = window.location.search ;
    if( $base.useString( s ) ) {
        var vals = s.substring(1, s.length).split('&') ;
        var len = vals.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( vals[i].indexOf( "=" ) >= 0 ) {
                var kv = vals[i].split('=') ;
                this.params[kv[0]] = kv[1] ;
            }
            else {
                this.params[vals[i]] = "" ;
            }
        }
    }
} ;
$getParams.get = function( key ) {
    if( $base.useString( key ) && useString( this.params[ key ] ) ) {
        return this.params[ key ] ;
    }
    return "" ;
} ;
$getParams.toString = function() {
    var ret = "" ;
    var cnt = 0 ;
    for( var k in this.params ) {
        if( cnt != 0 ) {
            ret += "," ;
        }
        ret += " key:" + k + " value:" + this.params[k] ;
        cnt ++ ;
    }
    return ret ;
} ;

// 指定IDにBase64形式の画像を表示.
viewImageByBase64 = function( id,mimeType,data ) {
    if( $base.isNull( id ) || $base.useString( mimeType ) == false || $base.isNull( data ) ) {
        return ;
    }
    $(id).src = "data:"+mimeType+";base64,"+data ;
} ;

// 指定イメージの内容を置き換える.
changeImage = function( id,url,backWindow ) {
    if( $base.isNull( id ) || $base.useString( url ) == false ) {
        return ;
    }
    if( $base.startsWith( id,"_img_" ) == false ) {
        id = "_img_" + id ;
    }
    if( $base.endsWith( id,"Id" ) == false ) {
        id = id + "Id" ;
    }
    var params = "t="+new Date().getTime() ;
    var p = url.indexOf( "?" ) ;
    if( p <= -1 ) {
        params = "t="+new Date().getTime() ;
        params = $base.addNoCookieBySession( params ) ;
    }
    else {
        params = url.substring( p+1 ) ;
        url = url.substring( 0,p ) ;
        params += "&t="+new Date().getTime() ;
        params = $base.addNoCookieBySession( params ) ;
    }
    url = url + "?" + params ;
    if( $base.isNull( backWindow ) == false && ( backWindow == true || backWindow == "true" ) ) {
        if( $base.isNull( window.opener ) == false && $base.isNull( window.opener.document ) == false &&
            $base.isNull( window.opener.document.getElementById(id) ) == false ) {
            window.opener.document.getElementById(id).src=url ;
        }
    }
    else {
        $(id).src=url ;
    }
}

// ブラウザwidthを取得.
width = function(){
    if(window.innerWidth){
        return window.innerWidth;
    }else if(document.documentElement && document.documentElement.clientWidth){
        return document.documentElement.clientWidth;
    }else if ( document.body && document.body.clientWidth){
        return document.body.clientWidth;
    }
    return -1 ;
}

// ブラウザHeightを取得.
height = function() {
    if(window.innerHeight){
        return window.innerHeight;
    }else if(document.documentElement && document.documentElement.clientHeight){
        return document.documentElement.clientHeight;
    }else if ( document.body && document.body.clientHeight){
        return document.body.clientHeight;
    }
    return -1 ;
}



////////////////////////////////////////////////////////////////////////////////
// ドキュメント系.
////////////////////////////////////////////////////////////////////////////////

// 対象スタイルシートにWidht,Heightを割り当てる.
putStyleWidhtHeight = function( clazz,width,height,etc ) {
    var prop = "" ;
    if( width > 0 ) {
        width /= 100 ;
        var x = Math.ceil( bwWidth() * width ) ;
        prop += " width: "+x+"px;" ;
    }
    if( height > 0 ) {
        height /= 100 ;
        var y = Math.ceil( bwHeight() * height ) ;
        prop += " height: "+y+"px;" ;
    }
    if( etc != null && ( etc = trim( etc ) ).length > 0 ) {
        prop += etc ;
        if( endsWith( etc,";" ) == false ) {
            prop += ";" ;
        }
    }
    if( prop.length > 0 ) {
        addCssValue( clazz,prop ) ;
    }
} ;

// クラス情報を取得.
getElementsByClassName = function(clazz) {
    var ret = [];
    var elems = (document.getElementsByTagName("*") || document.all);
    for (var i = 0; i < elems.length; i++) {
        if (elems[i].className == clazz) {
            ret[ret.length] = elems[i];
        }
    }
    return ret;
}

////////////////////////////////////////////////////////////////////////////////
// スタイルシート書き換え.
////////////////////////////////////////////////////////////////////////////////

// スタイルシートを書き換える.
addCssValue = function( selector, property ) {
    if( $base.isNull( selector ) || $base.isNull( property ) ) {
        return false ;
    }
    var sheets = getSheets() ;
    if( $base.isNull( sheets ) ) {
        return false ;
    }
    if( isMSIE == true ) {
        if( sheets[0].addRule ) { //IE
            sheets[0].addRule( selector, "{" + property + "}" );
            return true ;
        }
    }
    else {
        if( sheets[0].insertRule ) { //Mozilla
            sheets[0].insertRule( selector + "{" + property + "}", sheets[0].cssRules.length );
            return true ;
        }
    }
    return false;
}

// スタイルシートを取得する.
getCssValue = function( selector, property ) {
    var property = ( property.match( /-/ ) ) ? property.camelize( ) : property;
    var stylesheets = null ;
    var sheets = getSheets() ;
    if( $base.isNull( sheets ) ) {
        return false ;
    }
    if( isMSIE == true ) {
        stylesheets = sheets[0].rules        //IE
    }
    else {
        stylesheets = sheets[0].cssRules;    //Mozilla
    }
    for( var i = 0, len = stylesheets.length; i < len; i++ ) {
        var css = stylesheets[i];
        if( css.selectorText.toLowerCase( ) == selector.toLowerCase( ) ) {
            return css.style[ property ];
        }
    }
}

// 指定要素での有効スタイルシート値を取得.
getActiveCssValue = function( element, property, pseudo ) {
    var sheets = getSheets() ;
    if( $base.isNull( sheets ) ) {
        return false ;
    }
    if( $base.isMSIE == true ) {
        if( element.currentStyle ) {          //IE
            var property = ( property.match( /-/ ) ) ? property.camelize( ) : property;
            return element.currentStyle[ property.camelize( ) ];
        }
    }
    else {
        if( document.defaultView.getComputedStyle ) {    //Mozilla
            var property = ( isNull( property.match( /-/ ) ) ) ? property.deCamelize( ) : property;
            return document.defaultView.getComputedStyle( element, pseudo ).getPropertyValue( property );
        }
    }
    return "";
}

// スタイルシート一覧を取得.
getSheets = function() {
    if ( document.styleSheets &&
        document.styleSheets[0] &&
        document.styleSheets[0].title != null ) {
        return document.styleSheets;
    }
    return null ;
}

////////////////////////////////////////////////////////////////////////////////
// Cookie系.
////////////////////////////////////////////////////////////////////////////////

// cookie取得.
getCookie = function(key,  tmp1, tmp2, xx1, xx2, xx3) {
    if( isCookie == false ) {
        return  ;
    }
    tmp1 = " " + document.cookie + ";";
    xx1 = xx2 = 0;
    len = tmp1.length;
    while (xx1 < len) {
        xx2 = tmp1.indexOf(";", xx1);
        tmp2 = tmp1.substring(xx1 + 1, xx2);
        xx3 = tmp2.indexOf("=");
        if (tmp2.substring(0, xx3) == key) {
            return(unescape(tmp2.substring(xx3 + 1, xx2 - xx1 - 1)));
        }
        xx1 = xx2 + 1;
    }
    return("");
}

// cookie登録.
setCookie = function(key, val, tmp) {
    if( isCookie == false ) {
        return  ;
    }
    tmp = key + "=" + escape(val) + "; ";
    tmp += "expires=Tue, 31-Dec-2030 23:59:59; ";
    document.cookie = tmp;
}

// cookie削除.
clearCookie = function(key) {
    if( isCookie == false ) {
        return  ;
    }
    document.cookie = key + "=" + "x; expires=Tue, 1-Jan-1980 00:00:00;";
}

////////////////////////////////////////////////////////////////////////////////
// Validate系.
////////////////////////////////////////////////////////////////////////////////

// 文字列判別.
var STR_NUMBER = 0x00000001 ;       // 数値判別.
var STR_ALPHABET = 0x00000002 ;     // アルファベット判別.
var STR_ASCII = 0x00000004 ;        // アスキー判別.
var STR_KANA = 0x00000008 ;         // カタカナ判別.
var STR_HIRA = 0x00000010 ;         // ひらがな判別.

// Validateチェック.
var _use_validate_flag = false ;
var _all_validate_message = "" ;

// 正常メッセージを設定.
validate_successMessage = function( message,id ) {
    if( $base.useString( message) == false ) {
        return false ;
    }
    var viewId = "smsgId" ;
    if( $base.useString( id ) == false ) {
        id = "main" ;
    }
    viewId = viewId + id ;
    if( $base.isNull( $( viewId ) ) ) {
        return false ;
    }
    if( $base.useString( _all_validate_message ) ) {
        _all_validate_message += "<br>" ;
    }
    _all_validate_message += "[(s)id:" + id + "]:" + message ;
    if( $base.useString( $( viewId ).innerHTML ) == false ) {
        _use_validate_flag = true ;
        $( viewId ).innerHTML = message ;
    }
    else {
        _use_validate_flag = true ;
        $( viewId ).innerHTML = $( viewId ).innerHTML + "<br>" + message ;
    }
    return true ;
}


// 指定位置のエラーメッセージを設定.
validate_errorMessage = function( message,id ) {
    if( $base.useString( message) == false ) {
        return false ;
    }
    var viewId = "emsgId" ;
    if( $base.useString( id ) == false ) {
        id = "main" ;
    }
    viewId = viewId + id ;
    if( $base.isNull( $( viewId ) ) ) {
        return false ;
    }
    if( $base.useString( _all_validate_message ) ) {
        _all_validate_message += "<br>" ;
    }
    _all_validate_message += "[(e)id:" + id + "]:" + message ;
    if( $base.useString( $( viewId ).innerHTML ) == false ) {
        _use_validate_flag = true ;
        $( viewId ).innerHTML = message ;
    }
    else {
        _use_validate_flag = true ;
        $( viewId ).innerHTML = $( viewId ).innerHTML + "<br>" + message ;
    }
    return true ;
}

// すべてのメッセージを削除する.
validate_clear_all_message = function() {
    _all_validate_message = "" ;
    _use_validate_flag = false ;
    var tags = document.getElementsByTagName( "div" ) ;
    if( tags.length > 0 ) {
        var len = tags.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            var tag = tags[ i ] ;
            if( $base.isNull( tag ) == false &&
                $base.isNull( tag.id ) == false ) {
                if( $base.startsWith( tag.id,"emsgId" ) ||
                    $base.startsWith( tag.id,"smsgId" ) ) {
                    tag.innerHTML = "" ;
                }
            }
        }
    }
}

// validateエラーが検知されたかチェック.
is_validate = function() {
    var ret = _use_validate_flag ;
    _use_validate_flag = false ;
    return ret ;
}

// 文字列判別.
validate_string = function( type,name,message,id ) {
    if( $base.isNull( type ) || $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    if( ( type & STR_NUMBER ) != 0 ) {
        if( $base.isNumeric( val ) == false ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
        return false ;
    }
    if( ( type & STR_ALPHABET ) != 0 ) {
        if( /^[a-zA-Z]+$/.test(val) == false ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
        return false ;
    }
    if( ( type & STR_ASCII ) != 0 ) {
        if( /^[A-Za-z0-9]+$/.test(val) == false ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
        return false ;
    }
    if( ( type & STR_KANA ) != 0 ) {
        if( /^[ァ-ヴー]+$/.test(val) == false ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
        return false ;
    }
    if( ( type & STR_HIRA ) != 0 ) {
        if( /^[ぁ-ん]+$/.test(val) == false ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
        return false ;
    }
    return false ;
}

// 正規表現判別.
validate_match = function( match,name,message,id ) {
    if( $base.isNull( match ) || $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    if( match.test(val) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 郵便番号判別.
validate_zip = function( name,message,id ) {
    var match = /^\d{3}-\d{4}$/ ;
    return validate_match( match,name,message,id ) ;
}

// ISBN番号判別.
validate_isbn = function( name,message,id ) {
    var match = /ISBN\x20(?=.{13}$)\d{1,5}([- ])\d{1,7}\1\d{1,6}\1(\d|X)$/ ;
    return validate_match( match,name,message,id ) ;
}

// IPアドレス判別.
validate_ip = function( name,message,id ) {
    var match = /^(([0-2]*[0-9]+[0-9]+)\.([0-2]*[0-9]+[0-9]+)\.([0-2]*[0-9]+[0-9]+)\.([0-2]*[0-9]+[0-9]+))$/ ;
    return validate_match( match,name,message,id ) ;
}

// URL判別.
validate_url = function( name,message,id ) {
    var match = /^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i ;
    return validate_match( match,name,message,id ) ;
}

// E-MAIL判別.
validate_email = function( name,message,id ) {
    var match = /\w{1,}[@][\w\-]{1,}([.]([\w\-]{1,})){1,3}$/ ;
    return validate_match( match,name,message,id ) ;
}

// 指定日付が現在時間より前かチェック.
validagte_nowDate = function( name,message,id ) {
    if( $base.useString( name ) == false || $base.useString( message ) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"YearId") ) == true || $(name+"YearId").disabled == true ||
        $base.isNull( $(name+"MonthId") ) == true || $(name+"MonthId").disabled == true ||
        $base.isNull( $(name+"DayId") ) == true || $(name+"DayId").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var now = new Date() ;
    var check = new Date( parseInt( $( name + "YearId" ).value ),
        parseInt( $( name + "MonthId" ).value )-1,
        parseInt( $( name + "DayId" ).value ) ) ;
    if( now.getTime() >= check.getTime() ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定日付が、対象名の内容より前かチェック.
validate_dateBySrcDest = function( src,dest,message,id ) {
    if( $base.useString( src ) == false || $base.useString( dest ) == false ||
        $base.useString( message ) == false ) {
        return false ;
    }
    if( $base.isNull( $(src+"YearId") ) == true || $(src+"YearId").disabled == true ||
        $base.isNull( $(src+"MonthId") ) == true || $(src+"MonthId").disabled == true ||
        $base.isNull( $(src+"DayId") ) == true || $(src+"DayId").disabled == true ||
        $base.isNull( $(dest+"YearId") ) == true || $(dest+"YearId").disabled == true ||
        $base.isNull( $(dest+"MonthId") ) == true || $(dest+"MonthId").disabled == true ||
        $base.isNull( $(dest+"DayId") ) == true || $(dest+"DayId").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = dest ;
    }
    var srcTime = new Date( parseInt( $( src + "YearId" ).value ),
        parseInt( $( src + "MonthId" ).value )-1,
        parseInt( $( src + "DayId" ).value ) ) ;
    var destTime = new Date( parseInt( $( dest + "YearId" ).value ),
        parseInt( $( dest + "MonthId" ).value )-1,
        parseInt( $( dest + "DayId" ).value ) ) ;
    if( srcTime.getTime() >= destTime.getTime() ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// ファイルアップロード画像タイプチェック.
validate_image = function( name,message,id ) {
    if( $base.useString( name ) == false || $base.useString( message ) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    if( validate_no_use( name,message,id ) ) {
        return true ;
    }
    // サポート画像は、JPEG,GIF,PNGとする.
    var c = $( name + "Id" ).value ;
    if( $base.endsWith( c,".jpeg" ) == false &&
        $base.endsWith( c,".jpg" ) == false &&
        $base.endsWith( c,".jpe" ) == false &&
        $base.endsWith( c,".jfif" ) == false &&
        $base.endsWith( c,".jfi" ) == false &&
        $base.endsWith( c,".gif" ) == false &&
        $base.endsWith( c,".png" ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定拡張子チェック.
validate_fileNamePlus = function( plus,name,message,id ) {
    if( $base.useString( plus ) == false || $base.useString( name ) == false ||
        $base.useString( message ) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    if( validate_no_use( name,message,id ) ) {
        return true ;
    }
    var c = $( name + "Id" ).value ;
    if( plus.indexOf( "," ) != -1 ) {
        var t = plus.split( "," ) ;
        var len = t.length ;
        var errFlg = true ;
        for( var i = 0 ; i < len ; i ++ ) {
            var x = t[ i ] ;
            if( $base.startsWith( x,"." ) == false ) {
                x = "." + x ;
            }
            if( $base.endsWith( c,x ) == true ) {
                errFlg = false ;
                break ;
            }
        }
        if( errFlg ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
    }
    else {
        if( $base.startsWith( plus,"." ) == false ) {
            plus = "." + plus ;
        }
        if( $base.endsWith( c,plus ) == false ) {
            validate_errorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
}

// 指定開始条件不正チェック.
validate_startsWith = function( src,name,message,id ) {
    if( $base.isNull( src ) || $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    if( validate_no_use( name,message,id ) == true ) {
        return false ;
    }
    var c = $( name + "Id" ).value ;
    if( $base.startsWith( c,src ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定終了条件不正チェック.
validate_endsWith = function( src,name,message,id ) {
    if( $base.isNull( src ) || $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    if( validate_no_use( name,message,id ) == true ) {
        return false ;
    }
    var c = $( name + "Id" ).value ;
    if( $base.endsWith( c,src ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定条件非存在チェック.
validate_no_use = function( name,message,id ) {
    if( $base.useString( name ) == false || $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    if( /\S/.test(val) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定条件存在チェック.
validate_use = function( name,message,id ) {
    if( $base.useString( name ) == false || $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        return false ;
    }
    if( !/\S/.test(val) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定条件が、指定数より少ないかチェック.
validate_min = function( size,name,message,id ) {
    if( $base.isNull( size ) || $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    if( val.length < size ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定条件が、指定数より多いかチェック.
validate_max = function( size,name,message,id ) {
    if( $base.isNull( size ) || $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    if( val.length > size ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

// 指定条件が、指定数より多い／少ないかチェック.
validate_minMax = function( min,max,name,message,id ) {
    if( $base.isNull( min ) || $base.isNull( max ) ||
        $base.useString( name ) == false ||
        $base.useString( message) == false ) {
        return false ;
    }
    if( $base.isNull( $(name+"Id") ) == true || $(name+"Id").disabled == true ) {
        return false ;
    }
    if( $base.useString( id ) == false ) {
        id = name ;
    }
    var val = $(name+"Id").value ;
    if( $base.useString( val ) == false ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    if( val.length < min || val.length > max ) {
        validate_errorMessage( message,id ) ;
        return true ;
    }
    return false ;
}

