package org.maachang.dbm.engine ;

/**
 * 次キー内容取得用オブジェクト.
 * 
 * @version 2008/06/06
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
public class M2NextKey {
    
    /**
     * HashNo.
     */
    private int hashNo = 0 ;
    
    /**
     * 開始ポジション.
     */
    private int pos = -1 ;
    
    /**
     * 開始ファイルNo.
     */
    private int fileNo = -1 ;
    
    /**
     * キー内容.
     */
    private byte[] key = null ;
    
    /**
     * カウント.
     */
    private int count = 0 ;

    /**
     * カウントを１インクリメント.
     */
    public int addCount() {
        count ++ ;
        return count ;
    }

    /**
     * fileNo を取得.
     * <BR><BR>
     * @return fileNo が返されます.
     */
    public int getFileNo() {
        return fileNo;
    }

    /**
     * fileNo を設定.
     * <BR><BR>
     * @param fileNo fileNo を設定します.
     */
    public void setFileNo(int fileNo) {
        this.fileNo = fileNo;
    }

    /**
     * hashNo を取得.
     * <BR><BR>
     * @return hashNo が返されます.
     */
    public int getHashNo() {
        return hashNo;
    }

    /**
     * hashNo を設定.
     * <BR><BR>
     * @param hashNo hashNoを設定します.
     */
    public void setHashNo( int hashNo ) {
        this.hashNo = hashNo ;
    }

    /**
     * key を取得.
     * <BR><BR>
     * @return key が返されます.
     */
    public byte[] getKey() {
        return key;
    }

    /**
     * key を設定.
     * <BR><BR>
     * @param key key を設定します.
     */
    public void setKey(byte[] key) {
        this.key = key;
    }

    /**
     * pos を取得.
     * <BR><BR>
     * @return pos が返されます.
     */
    public int getPos() {
        return pos;
    }

    /**
     * pos を設定.
     * <BR><BR>
     * @param pos pos を設定します.
     */
    public void setPos(int pos) {
        this.pos = pos;
    }
    
    /**
     * カウントを取得.
     * <BR><BR>
     * @return int カウントが返されます.
     */
    public int getCount() {
        return count ;
    }
}
