#include <windows.h>
#include "../../include/org_maachang_util_nativeio_NativeIO.h"

#pragma comment(lib,"jvm.lib")

/** V[N. **/
BOOL _seek( HANDLE handle,jlong seek ) {
    unsigned long low,high,res ;
    if( seek <= -1 ) {
        return FALSE ;
    }
    low = ( unsigned long )( seek & 0x00000000ffffffff ) ;
    high = ( unsigned long )( ( seek & 0xffffffff00000000 ) >> 32 ) ;
    res = 0xffffffff ;
    if( high == 0 ){
        res = SetFilePointer( handle,low,NULL,FILE_BEGIN ) ;
    }else{
        res = SetFilePointer( handle,low,(long*)&high,FILE_BEGIN ) ;
    }
    if( res == 0xffffffff ){
        if( GetLastError() != NO_ERROR ) {
            return FALSE ;
        }
    }
    return TRUE ;
}

/** t@CI[v. **/
JNIEXPORT jlong JNICALL Java_org_maachang_util_nativeio_NativeIO_open
  (JNIEnv* env, jclass c, jint mode, jint rw, jbyteArray bpath ) {
    char* path ;
    HANDLE ret ;
    DWORD flg ;
    unsigned int rwMode ;
    path = (*env)->GetPrimitiveArrayCritical(env, bpath, NULL);
    flg = FILE_ATTRIBUTE_NOT_CONTENT_INDEXED ;    // Index𗘗pȂ.
    if( mode == 0 ) {
        flg = flg | FILE_FLAG_RANDOM_ACCESS |     // _ANZXɓ.
            FILE_FLAG_POSIX_SEMANTICS ;           // POSIXdl.
    }
    else {
        flg |= FILE_FLAG_SEQUENTIAL_SCAN ;        // V[PXɓ.
    }
    rwMode = ( rw == 0 ) ? GENERIC_READ :
        ( ( rw == 1 ) ? GENERIC_WRITE : ( GENERIC_READ | GENERIC_WRITE ) ) ;
    ret = CreateFile(
        path,
        rwMode,
        0,
        NULL,
        OPEN_ALWAYS,// t@CȂ΍쐬A΁Â܂ܗp.
        flg,
        NULL ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, bpath, path, JNI_ABORT);
    if( ret == INVALID_HANDLE_VALUE ) {
        return ( jlong )-1 ;
    }
    return ( jlong )ret ;
}

/** t@CN[Y. **/
JNIEXPORT void JNICALL Java_org_maachang_util_nativeio_NativeIO_close
  (JNIEnv* env, jclass c, jlong h ) {
    CloseHandle( ( HANDLE )h ) ;
}

/** ǂݍݏ. **/
JNIEXPORT jint JNICALL Java_org_maachang_util_nativeio_NativeIO_read
  (JNIEnv* env, jclass c, jlong h, jlong seek, jbyteArray out, jint off, jint len) {
    long ret ;
    char* obyte ;
    HANDLE handle ;
    BOOL res ;
    handle = ( HANDLE )h ;
    obyte = (*env)->GetPrimitiveArrayCritical(env, out, NULL) ;
    _seek( handle,seek ) ;
    res = ReadFile( handle,( char* )(obyte+off),len,( unsigned long* )&ret,NULL ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, out, obyte, JNI_ABORT);
    if( res == FALSE ) {
        ret = -1 ;
    }
    return ( jint )ret ;
}

/** ݏ **/
JNIEXPORT jint JNICALL Java_org_maachang_util_nativeio_NativeIO_write
  (JNIEnv* env, jclass c, jlong h, jlong seek, jbyteArray in, jint off, jint len) {
    char* ibyte ;
    HANDLE handle ;
    BOOL res ;
    unsigned long ret = 0 ;
    handle = ( HANDLE )h ;
    ibyte = (*env)->GetPrimitiveArrayCritical(env, in, NULL) ;
    _seek( handle,seek ) ;
    res = WriteFile( handle,( char* )(ibyte+off),len,&ret,NULL ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, in, ibyte, JNI_ABORT);
    if( res == FALSE ) {
        return -1 ;
    }
    return 0 ;
}

/** t@CTCY擾 **/
JNIEXPORT jlong JNICALL Java_org_maachang_util_nativeio_NativeIO_getLength
  (JNIEnv* env, jclass c, jlong h ) {
    unsigned long sizeLow = 0 ;
    unsigned long sizeHigh = 0 ;
    HANDLE handle = ( HANDLE )h ;
    if( handle == INVALID_HANDLE_VALUE ) {
        return -1 ;
    }
    sizeLow = GetFileSize( handle,&sizeHigh ) ;
    if( sizeLow == 0xffffffff ) {
        if( GetLastError() != ERROR_SUCCESS ) {
            return -1 ;
        }
    }
    return ( jlong )( ( ( jlong )sizeLow & 0x00000000ffffffff ) |
        ( ( ( jlong )sizeHigh & 0x00000000ffffffff ) << 32 ) ) ; ;
}

/** t@CTCYݒ **/
JNIEXPORT jint JNICALL Java_org_maachang_util_nativeio_NativeIO_setLength
  (JNIEnv* env, jclass c, jlong h , jlong len ) {
    long low,high ;
    unsigned long res ;
    HANDLE handle = ( HANDLE )h ;
    if( handle == INVALID_HANDLE_VALUE ) {
        return FALSE ;
    }
    low = ( unsigned long )( len & 0x00000000ffffffff ) ;
    high = ( unsigned long )( ( len & 0xffffffff00000000 ) >> 32 ) ;
    res = SetFilePointer( handle,low,&high,FILE_BEGIN ) ;
    if( res == 0xffffffff ) {
        if(  GetLastError() != NO_ERROR ) {
            return -1 ;
        }
    }
    if( SetEndOfFile( handle ) == FALSE ) {
        return -1 ;
    }
    return 0 ;
}
