package org.maachang.connector ;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * ConnectorQueue.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
class ConnectorQueue {
    private ConcurrentLinkedQueue<ConnectorSession> queue = new ConcurrentLinkedQueue<ConnectorSession>() ;
    
    public ConnectorQueue() {
    }
    
    public synchronized void destroy() {
        queue.clear() ;
    }
    
    public synchronized void append( ConnectorSession s ) {
        if( s != null || s.isClosed() == false ) {
            queue.offer( s ) ;
        }
    }
    
    public synchronized ConnectorSession getQueue() {
        return queue.poll() ;
    }
}
